/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.platform;

import io.gravitee.definition.model.Policy;
import io.gravitee.gateway.policy.PolicyFactory;
import io.gravitee.gateway.policy.impl.CachedPolicyConfigurationFactory;
import io.gravitee.gateway.policy.impl.DefaultPolicyManager;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformPolicyManager
extends DefaultPolicyManager {
    private final Logger logger = LoggerFactory.getLogger(PlatformPolicyManager.class);
    Set<Policy> dependencies = new HashSet<Policy>();

    public PlatformPolicyManager(PolicyFactory policyFactory) {
        super(policyFactory);
    }

    public void setDependencies(Set<Policy> dependencies) {
        this.dependencies = dependencies;
        this.restart();
    }

    private void restart() {
        try {
            this.logger.info("Restart policy manager");
            this.stop();
            this.start();
        }
        catch (Exception e) {
            this.logger.error("Impossible to restart platform policy manager", (Throwable)e);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.policyConfigurationFactory instanceof CachedPolicyConfigurationFactory) {
            ((CachedPolicyConfigurationFactory)this.policyConfigurationFactory).clear();
        }
    }

    public Set<Policy> dependencies() {
        return this.dependencies;
    }
}

