/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.env;

import io.gravitee.common.util.EnvironmentUtils;
import io.gravitee.node.api.configuration.Configuration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class GatewayConfiguration
implements InitializingBean {
    static final String SHARDING_TAGS_SYSTEM_PROPERTY = "tags";
    private static final String SHARDING_TAGS_SEPARATOR = ",";
    static final String ZONE_SYSTEM_PROPERTY = "zone";
    static final String MULTI_TENANT_CONFIGURATION = "tenant";
    static final String MULTI_TENANT_SYSTEM_PROPERTY = "gravitee.tenant";
    static final String ENVIRONMENTS_SYSTEM_PROPERTY = "environments";
    private static final String ENVIRONMENTS_SEPARATOR = ",";
    static final String ORGANIZATION_SYSTEM_PROPERTY = "organizations";
    private static final String ORGANIZATIONS_SEPARATOR = ",";
    private static final String ALLOW_OVERLAPPING_API_CONTEXTS_PROPERTY = "api.allowOverlappingContext";
    private Optional<List<String>> shardingTags;
    private Optional<String> zone;
    private Optional<String> tenant;
    private Optional<List<String>> environments;
    private Optional<List<String>> organizations;
    @Autowired
    private Configuration configuration;

    public void afterPropertiesSet() {
        this.initShardingTags();
        this.initZone();
        this.initTenant();
        this.initOrganizations();
        this.initEnvironments();
        this.initVertxWebsocket();
    }

    private void initVertxWebsocket() {
        Boolean websocketEnabled = (Boolean)this.configuration.getProperty("http.websocket.enabled", Boolean.class, (Object)false);
        System.setProperty("vertx.disableWebsockets", Boolean.toString(websocketEnabled == false));
    }

    private void initShardingTags() {
        String systemPropertyTags = System.getProperty(SHARDING_TAGS_SYSTEM_PROPERTY);
        String tags = systemPropertyTags == null ? this.configuration.getProperty(SHARDING_TAGS_SYSTEM_PROPERTY) : systemPropertyTags;
        this.shardingTags = tags != null && !tags.isEmpty() ? Optional.of(Arrays.asList(tags.split(","))) : Optional.empty();
    }

    public Optional<List<String>> shardingTags() {
        return this.shardingTags;
    }

    private void initZone() {
        String envPropertyZone;
        String systemPropertyZone = System.getProperty(ZONE_SYSTEM_PROPERTY);
        if (systemPropertyZone == null || systemPropertyZone.isEmpty()) {
            systemPropertyZone = null;
        }
        if ((envPropertyZone = this.configuration.getProperty(ZONE_SYSTEM_PROPERTY)) == null || envPropertyZone.isEmpty()) {
            envPropertyZone = null;
        }
        this.zone = Optional.ofNullable(systemPropertyZone == null ? envPropertyZone : systemPropertyZone);
    }

    public Optional<String> zone() {
        return this.zone;
    }

    private void initTenant() {
        String envPropertyTenant;
        String systemPropertyTenant = System.getProperty(MULTI_TENANT_SYSTEM_PROPERTY);
        if (systemPropertyTenant == null || systemPropertyTenant.isEmpty()) {
            systemPropertyTenant = null;
        }
        if ((envPropertyTenant = this.configuration.getProperty(MULTI_TENANT_CONFIGURATION)) == null || envPropertyTenant.isEmpty()) {
            envPropertyTenant = null;
        }
        this.tenant = Optional.ofNullable(systemPropertyTenant == null ? envPropertyTenant : systemPropertyTenant);
    }

    public Optional<String> tenant() {
        return this.tenant;
    }

    public boolean useLegacyEnvironmentHrids() {
        return (Boolean)this.configuration.getProperty("useLegacyEnvironmentHrids", Boolean.class, (Object)true);
    }

    private void initOrganizations() {
        String systemPropertyOrganizations = System.getProperty(ORGANIZATION_SYSTEM_PROPERTY);
        String orgs = systemPropertyOrganizations == null ? this.configuration.getProperty(ORGANIZATION_SYSTEM_PROPERTY) : systemPropertyOrganizations;
        this.organizations = orgs != null && !orgs.isEmpty() ? Optional.of(Arrays.asList(orgs.split(","))) : Optional.empty();
    }

    public Optional<List<String>> organizations() {
        return this.organizations;
    }

    private void initEnvironments() {
        String systemPropertyEnvironments = System.getProperty(ENVIRONMENTS_SYSTEM_PROPERTY);
        String envs = systemPropertyEnvironments == null ? this.configuration.getProperty(ENVIRONMENTS_SYSTEM_PROPERTY) : systemPropertyEnvironments;
        this.environments = envs != null && !envs.isEmpty() ? Optional.of(Arrays.asList(envs.split(","))) : Optional.empty();
    }

    public Optional<List<String>> environments() {
        return this.environments;
    }

    public boolean hasMatchingTags(Set<String> tags) {
        return EnvironmentUtils.hasMatchingTags(this.shardingTags(), tags);
    }

    public boolean allowOverlappingApiContexts() {
        return (Boolean)this.configuration.getProperty(ALLOW_OVERLAPPING_API_CONTEXTS_PROPERTY, Boolean.class, (Object)false);
    }
}

