/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.env;

import io.gravitee.gateway.env.RequestTimeoutConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TimeoutConfiguration {
    public static final Logger log = LoggerFactory.getLogger(TimeoutConfiguration.class);

    @Bean
    public RequestTimeoutConfiguration httpRequestTimeoutConfiguration(@Value(value="${http.requestTimeout:#{null}}") Long httpRequestTimeout, @Value(value="${http.requestTimeoutGraceDelay:30}") long httpRequestTimeoutGraceDelay) {
        if (httpRequestTimeout == null) {
            log.warn("Http request timeout cannot be unset. Setting it to default value: 30_000 ms");
            httpRequestTimeout = 30000L;
        } else if (httpRequestTimeout <= 0L) {
            log.warn("A proper timeout (greater than 0) should be set in order to avoid unclose connection, suggested value is 30_000 ms");
        }
        return new RequestTimeoutConfiguration(httpRequestTimeout, httpRequestTimeoutGraceDelay);
    }
}

