/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.buffer.netty;

import io.gravitee.gateway.api.buffer.Buffer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import io.reactivex.rxjava3.annotations.NonNull;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class BufferImpl
implements Buffer {
    private ByteBuf buffer;

    BufferImpl() {
        this(0);
    }

    BufferImpl(ByteBuf nativeBuffer) {
        this.buffer = nativeBuffer;
    }

    BufferImpl(int initialSizeHint) {
        this.buffer = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.buffer((int)initialSizeHint, (int)Integer.MAX_VALUE));
    }

    BufferImpl(byte[] bytes) {
        this.buffer = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.buffer((int)bytes.length, (int)Integer.MAX_VALUE)).writeBytes(bytes);
    }

    BufferImpl(String str, String enc) {
        this(str.getBytes(Charset.forName(Objects.requireNonNull(enc))));
    }

    BufferImpl(String str, Charset cs) {
        this(str.getBytes(cs));
    }

    BufferImpl(String str) {
        this(str, StandardCharsets.UTF_8);
    }

    @NonNull
    public Buffer appendBuffer(Buffer buff) {
        ByteBuf cb = buff.getNativeBuffer();
        return this.appendBuf(cb, cb.readableBytes());
    }

    public Buffer appendBuffer(Buffer buff, int length) {
        ByteBuf cb = buff.getNativeBuffer();
        return this.appendBuf(cb, Math.min(buff.length(), length));
    }

    public Buffer appendString(String str, String charset) {
        return this.append(str, Charset.forName(Objects.requireNonNull(charset)));
    }

    public Buffer appendString(String str) {
        return this.append(str, CharsetUtil.UTF_8);
    }

    private Buffer append(String str, Charset charset) {
        return this.appendBuffer(new BufferImpl(str.getBytes(charset)));
    }

    private Buffer appendBuf(ByteBuf cb, int length) {
        this.buffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.buffer, cb.slice(0, length)});
        return this;
    }

    public String toString() {
        return this.buffer.toString(StandardCharsets.UTF_8);
    }

    public String toString(String enc) {
        return this.buffer.toString(Charset.forName(enc));
    }

    public String toString(Charset enc) {
        return this.buffer.toString(enc);
    }

    public byte[] getBytes() {
        byte[] arr = new byte[this.buffer.writerIndex() - this.buffer.readerIndex()];
        this.buffer.getBytes(this.buffer.readerIndex(), arr);
        return arr;
    }

    public int length() {
        return this.buffer.writerIndex();
    }

    public ByteBuf getNativeBuffer() {
        return this.buffer;
    }
}

