/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.services.healthcheck.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.services.healthcheck.HealthCheckResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class ResponseDeserializer
extends StdScalarDeserializer<HealthCheckResponse> {
    public ResponseDeserializer(Class<HealthCheckResponse> vc) {
        super(vc);
    }

    public HealthCheckResponse deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        HealthCheckResponse response = new HealthCheckResponse();
        JsonNode assertionsNode = node.get("assertions");
        if (assertionsNode != null) {
            ArrayList assertions = new ArrayList();
            assertionsNode.elements().forEachRemaining(assertionNode -> assertions.add(assertionNode.asText()));
            response.setAssertions(assertions);
        }
        if (response.getAssertions().isEmpty()) {
            response.setAssertions(Collections.singletonList("#response.status == 200"));
        }
        return response;
    }
}

