/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.services.dynamicproperty.deser.http;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.common.http.HttpHeader;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.services.dynamicproperty.http.HttpDynamicPropertyProviderConfiguration;
import java.io.IOException;
import java.util.ArrayList;

public class HttpDynamicPropertyProviderConfigurationDeserializer
extends StdScalarDeserializer<HttpDynamicPropertyProviderConfiguration> {
    public HttpDynamicPropertyProviderConfigurationDeserializer(Class<HttpDynamicPropertyProviderConfiguration> vc) {
        super(vc);
    }

    public HttpDynamicPropertyProviderConfiguration deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode bodyNode;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        HttpDynamicPropertyProviderConfiguration configuration = new HttpDynamicPropertyProviderConfiguration();
        JsonNode urlNode = node.get("url");
        if (urlNode == null) {
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)"[dynamic-property] [HTTP] URL is required");
        }
        configuration.setUrl(urlNode.asText());
        JsonNode specificationNode = node.get("specification");
        if (specificationNode == null) {
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)"[dynamic-property] [HTTP] Specification is required");
        }
        configuration.setSpecification(specificationNode.asText());
        JsonNode useSystemProxy = node.get("useSystemProxy");
        if (useSystemProxy != null) {
            configuration.setUseSystemProxy(useSystemProxy.asBoolean());
        }
        JsonNode methodNode = node.get("method");
        HttpMethod method = HttpMethod.GET;
        if (methodNode != null) {
            try {
                method = HttpMethod.valueOf((String)methodNode.asText());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        configuration.setMethod(method);
        JsonNode headersNode = node.get("headers");
        if (headersNode != null) {
            ArrayList headers = new ArrayList();
            headersNode.elements().forEachRemaining(headerNode -> {
                if (headerNode.findValue("name") != null & headerNode.findValue("value") != null) {
                    HttpHeader header = new HttpHeader();
                    header.setName(headerNode.findValue("name").asText());
                    header.setValue(headerNode.findValue("value").asText());
                    headers.add(header);
                }
            });
            configuration.setHeaders(headers);
        }
        configuration.setBody((bodyNode = node.get("body")) != null ? bodyNode.asText() : null);
        return configuration;
    }
}

