/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.services.core.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.Service;
import java.io.IOException;

public abstract class ServiceDeserializer<T extends Service>
extends StdScalarDeserializer<T> {
    public ServiceDeserializer(Class<T> vc) {
        super(vc);
    }

    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        try {
            T service = this.createServiceInstance();
            this.deserialize(service, jsonParser, node, deserializationContext);
            return service;
        }
        catch (Exception ex) {
            throw JsonMappingException.from((DeserializationContext)deserializationContext, (String)ex.getMessage());
        }
    }

    protected void deserialize(T service, JsonParser jsonParser, JsonNode node, DeserializationContext ctxt) throws IOException {
        JsonNode serviceEnabledNode = node.get("enabled");
        if (serviceEnabledNode != null) {
            service.setEnabled(serviceEnabledNode.asBoolean(false));
        } else {
            service.setEnabled(true);
        }
    }

    private T createServiceInstance() throws Exception {
        Class serviceClass = this.handledType();
        return (T)((Service)serviceClass.newInstance());
    }
}

