/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.plugins.resource.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.plugins.resources.Resource;
import java.io.IOException;

public class ResourceDeserializer
extends StdScalarDeserializer<Resource> {
    public ResourceDeserializer(Class<Resource> vc) {
        super(vc);
    }

    public Resource deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Resource resource = new Resource();
        JsonNode nameNode = node.get("name");
        if (nameNode == null) {
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)"[resource] Name is required");
        }
        resource.setName(nameNode.asText());
        JsonNode typeNode = node.get("type");
        if (typeNode == null) {
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)"[resource] Type is required");
        }
        resource.setType(typeNode.asText());
        JsonNode configurationNode = node.get("configuration");
        if (configurationNode == null) {
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)"[resource] Configuration is required");
        }
        resource.setConfiguration(configurationNode.toString());
        JsonNode enabledNode = node.get("enabled");
        if (enabledNode != null) {
            resource.setEnabled(enabledNode.asBoolean(true));
        } else {
            resource.setEnabled(true);
        }
        return resource;
    }
}

