/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.ser.ssl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.gravitee.definition.model.ssl.KeyStore;
import java.io.IOException;

public abstract class KeyStoreSerializer<T extends KeyStore>
extends StdScalarSerializer<T> {
    public KeyStoreSerializer(Class<T> t) {
        super(t);
    }

    public void serialize(T keyStore, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        this.doSerialize(keyStore, jgen, provider);
        jgen.writeEndObject();
    }

    public void serializeWithType(T value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(value, g, provider);
    }

    protected void doSerialize(T keyStore, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
        jgen.writeStringField("type", keyStore.getType().name());
    }

    protected void writeStringField(JsonGenerator jgen, String field, String value) throws IOException {
        if (value != null && !value.isEmpty()) {
            jgen.writeStringField(field, value);
        }
    }
}

