/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.gravitee.definition.model.flow.Step;
import java.io.IOException;

public class StepSerializer
extends StdScalarSerializer<Step> {
    public StepSerializer(Class<Step> vc) {
        super(vc);
    }

    public void serialize(Step step, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("name", step.getName());
        if (step.getDescription() != null) {
            jgen.writeStringField("description", step.getDescription());
        }
        jgen.writeBooleanField("enabled", step.isEnabled());
        jgen.writeStringField("policy", step.getPolicy());
        if (step.getCondition() != null && !step.getCondition().isBlank()) {
            jgen.writeStringField("condition", step.getCondition());
        }
        jgen.writeFieldName("configuration");
        jgen.writeRawValue(step.getConfiguration());
        jgen.writeEndObject();
    }
}

