/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.plugins.resources.Resource;
import java.io.IOException;
import java.util.Collections;

public class ApiSerializer
extends StdScalarSerializer<Api> {
    public ApiSerializer(Class<Api> t) {
        super(t);
    }

    public void serialize(Api api, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        this.serializeContent(api, jgen, provider);
        jgen.writeEndObject();
    }

    public void serializeContent(Api api, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStringField("id", api.getId());
        jgen.writeStringField("name", api.getName());
        jgen.writeObjectField("version", (Object)api.getVersion());
        if (api.getDefinitionVersion() != null) {
            jgen.writeObjectField("gravitee", (Object)api.getDefinitionVersion().getLabel());
        }
        if (api.getExecutionMode() != null) {
            jgen.writeObjectField("execution_mode", (Object)api.getExecutionMode().getLabel());
        }
        if (api.getFlowMode() != null) {
            jgen.writeObjectField("flow_mode", (Object)api.getFlowMode().toString().toUpperCase());
        }
        if (api.getProxy() != null) {
            jgen.writeObjectField("proxy", (Object)api.getProxy());
        }
        if (api.getDefinitionVersion() == DefinitionVersion.V1) {
            if (api.getPaths() != null) {
                jgen.writeObjectFieldStart("paths");
                api.getPaths().forEach((s, path) -> {
                    try {
                        jgen.writeObjectField(s, path);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
                jgen.writeEndObject();
            }
        } else if (api.getDefinitionVersion() == DefinitionVersion.V2) {
            if (api.getFlows() != null && !api.getFlows().isEmpty()) {
                jgen.writeObjectField("flows", (Object)api.getFlows());
            }
            if (api.getPlans() != null && !api.getPlans().isEmpty()) {
                jgen.writeObjectField("plans", (Object)api.getPlans());
            }
        }
        if (api.getServices() != null && !api.getServices().isEmpty()) {
            jgen.writeObjectField("services", (Object)api.getServices());
        }
        if (api.getResources() != null && !api.getResources().isEmpty()) {
            jgen.writeArrayFieldStart("resources");
            for (Resource resource : api.getResources()) {
                jgen.writeObject((Object)resource);
            }
            jgen.writeEndArray();
        }
        if (api.getProperties() != null && api.getProperties().getValues() != null) {
            jgen.writeObjectField("properties", (Object)api.getProperties());
        } else {
            jgen.writeObjectField("properties", Collections.emptyList());
        }
        if (api.getTags() != null && !api.getTags().isEmpty()) {
            jgen.writeArrayFieldStart("tags");
            api.getTags().forEach(tag -> {
                try {
                    jgen.writeObject(tag);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            jgen.writeEndArray();
        }
        if (api.getPathMappings() != null && !api.getPathMappings().isEmpty()) {
            jgen.writeArrayFieldStart("path_mappings");
            api.getPathMappings().keySet().forEach(pathMapping -> {
                try {
                    jgen.writeObject(pathMapping);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            jgen.writeEndArray();
        }
        if (api.getResponseTemplates() != null && !api.getResponseTemplates().isEmpty()) {
            jgen.writeObjectField("response_templates", (Object)api.getResponseTemplates());
        }
    }
}

