/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.definition.jackson.datatype.api.deser.AbstractStdScalarDeserializer;
import io.gravitee.definition.model.Property;
import java.io.IOException;

public class PropertyDeserializer
extends AbstractStdScalarDeserializer<Property> {
    public PropertyDeserializer(Class<Property> vc) {
        super(vc);
    }

    public Property deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        boolean encrypted = false;
        JsonNode keyNode = node.get("key");
        if (keyNode == null) {
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)"Key property is required");
        }
        String key = keyNode.asText();
        JsonNode valueNode = node.get("value");
        if (valueNode == null) {
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)"Value property is required");
        }
        String value = valueNode.asText();
        if (node.has("encrypted")) {
            encrypted = node.get("encrypted").asBoolean(false);
        }
        Property property = new Property(key, value, encrypted);
        JsonNode isDynamicNode = node.get("dynamic");
        if (isDynamicNode != null) {
            boolean isDynamic = isDynamicNode.asBoolean(false);
            property.setDynamic(isDynamic);
        } else {
            property.setDynamic(false);
        }
        return property;
    }
}

