/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.HttpResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpResponseDeserializer
extends StdScalarDeserializer<HttpResponse> {
    public HttpResponseDeserializer(Class<HttpResponse> vc) {
        super(vc);
    }

    public HttpResponse deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JsonProcessingException {
        JsonNode jsonNode = (JsonNode)jp.getCodec().readTree(jp);
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setBody(this.readStringValue(jsonNode, "body"));
        JsonNode statusCodeNode = jsonNode.get("statusCode");
        httpResponse.statusCode(statusCodeNode.asInt());
        JsonNode headersNode = jsonNode.get("headers");
        if (headersNode != null && !headersNode.isEmpty(null)) {
            httpResponse.setHeaders((Map)headersNode.traverse(jp.getCodec()).readValueAs((TypeReference)new TypeReference<HashMap<String, List<String>>>(this){}));
        }
        return httpResponse;
    }

    private String readStringValue(JsonNode rootNode, String fieldName) {
        JsonNode fieldNode = rootNode.get(fieldName);
        if (fieldNode != null) {
            return fieldNode.asText();
        }
        return null;
    }
}

