/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.PolicyScope;
import io.gravitee.definition.model.debug.DebugStep;
import io.gravitee.definition.model.debug.DebugStepError;
import io.gravitee.definition.model.debug.DebugStepStatus;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DebugStepDeserializer
extends StdScalarDeserializer<DebugStep> {
    public DebugStepDeserializer(Class<DebugStep> vc) {
        super(vc);
    }

    public DebugStep deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        DebugStep debugStep = new DebugStep();
        debugStep.setPolicyInstanceId(this.readStringValue(node, "policyInstanceId"));
        debugStep.setPolicyId(this.readStringValue(node, "policyId"));
        debugStep.setScope(PolicyScope.valueOf((String)this.readStringValue(node, "scope")));
        debugStep.setStatus(DebugStepStatus.valueOf((String)this.readStringValue(node, "status")));
        debugStep.setCondition(this.readStringValue(node, "condition"));
        JsonNode error = node.get("error");
        if (error != null && !error.isEmpty(null)) {
            DebugStepError debugStepError = (DebugStepError)error.traverse(jp.getCodec()).readValueAs(DebugStepError.class);
            debugStep.setError(debugStepError);
        }
        debugStep.setDuration(Long.valueOf(node.get("duration").asLong()));
        JsonNode resultNode = node.get("result");
        if (resultNode != null && !resultNode.isEmpty(null)) {
            Map result = (Map)resultNode.traverse(jp.getCodec()).readValueAs((TypeReference)new TypeReference<HashMap<String, Object>>(this){});
            debugStep.setResult(result);
        }
        debugStep.setStage(this.readStringValue(node, "stage"));
        return debugStep;
    }

    private String readStringValue(JsonNode rootNode, String fieldName) {
        JsonNode fieldNode = rootNode.get(fieldName);
        if (fieldNode != null) {
            return fieldNode.asText();
        }
        return null;
    }
}

