/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.jackson.datatype.api.deser.ApiDeserializer;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.HttpRequest;
import io.gravitee.definition.model.HttpResponse;
import io.gravitee.definition.model.debug.DebugApiV2;
import io.gravitee.definition.model.debug.DebugMetrics;
import io.gravitee.definition.model.debug.DebugStep;
import io.gravitee.definition.model.debug.PreprocessorStep;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugApiDeserializer
extends StdScalarDeserializer<DebugApiV2> {
    private final Logger logger = LoggerFactory.getLogger(DebugApiDeserializer.class);
    private final ApiDeserializer base = new ApiDeserializer<Api>(Api.class);

    public DebugApiDeserializer(Class<?> vc) {
        super(vc);
    }

    public DebugApiV2 deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode metricsNode;
        JsonNode backendResponseNode;
        JsonNode preprocessorStepNode;
        JsonNode resultNode;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        DebugApiV2 debugApi = this.base.deserialize(jp, ctxt, new DebugApiV2(), node);
        JsonNode requestNode = node.get("request");
        if (requestNode == null) {
            this.logger.error("A request property is required for {}", (Object)debugApi.getName());
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)("A request property is required for " + debugApi.getName()));
        }
        debugApi.setRequest((HttpRequest)requestNode.traverse(jp.getCodec()).readValueAs(HttpRequest.class));
        JsonNode responseNode = node.get("response");
        if (responseNode != null) {
            debugApi.setResponse((HttpResponse)responseNode.traverse(jp.getCodec()).readValueAs(HttpResponse.class));
        }
        if ((resultNode = node.get("debugSteps")) != null) {
            debugApi.setDebugSteps((List)resultNode.traverse(jp.getCodec()).readValueAs((TypeReference)new TypeReference<List<DebugStep>>(this){}));
        }
        if ((preprocessorStepNode = node.get("preprocessorStep")) != null) {
            debugApi.setPreprocessorStep((PreprocessorStep)preprocessorStepNode.traverse(jp.getCodec()).readValueAs(PreprocessorStep.class));
        }
        if ((backendResponseNode = node.get("backendResponse")) != null) {
            debugApi.setBackendResponse((HttpResponse)backendResponseNode.traverse(jp.getCodec()).readValueAs(HttpResponse.class));
        }
        if ((metricsNode = node.get("metrics")) != null) {
            debugApi.setMetrics((DebugMetrics)metricsNode.traverse(jp.getCodec()).readValueAs(DebugMetrics.class));
        }
        return debugApi;
    }
}

