/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.common.util.LinkedCaseInsensitiveSet;
import io.gravitee.definition.model.Cors;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorsDeserializer
extends StdScalarDeserializer<Cors> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CorsDeserializer.class);

    public CorsDeserializer(Class<Cors> vc) {
        super(vc);
    }

    public Cors deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Cors cors = new Cors();
        JsonNode enabledNode = node.get("enabled");
        if (enabledNode != null) {
            boolean enabled = enabledNode.asBoolean(false);
            cors.setEnabled(enabled);
        }
        if (cors.isEnabled()) {
            CorsDeserializer.handleCredentials(node, cors);
            CorsDeserializer.handleOrigin(node, cors);
            CorsDeserializer.handleHeaders(node, cors);
            CorsDeserializer.handleMethods(node, cors);
            CorsDeserializer.handleExposeHeaders(node, cors);
            JsonNode maxAgeNode = node.get("maxAge");
            if (maxAgeNode != null) {
                cors.setAccessControlMaxAge(maxAgeNode.asInt(-1));
            } else {
                cors.setAccessControlMaxAge(-1);
            }
            cors.setRunPolicies(node.path("runPolicies").asBoolean(false));
        }
        return cors;
    }

    private static void handleCredentials(JsonNode node, Cors cors) {
        JsonNode allowCredentialsNode = node.get("allowCredentials");
        if (allowCredentialsNode != null) {
            boolean allowCredentials = allowCredentialsNode.asBoolean(false);
            cors.setAccessControlAllowCredentials(allowCredentials);
        } else {
            cors.setAccessControlAllowCredentials(false);
        }
    }

    private static void handleOrigin(JsonNode node, Cors cors) {
        JsonNode allowOriginNode = node.get("allowOrigin");
        LinkedCaseInsensitiveSet allowOrigin = new LinkedCaseInsensitiveSet();
        LinkedHashSet allowOriginRegex = new LinkedHashSet();
        cors.setAccessControlAllowOrigin((Set)allowOrigin);
        cors.setAccessControlAllowOriginRegex(allowOriginRegex);
        if (allowOriginNode != null) {
            allowOriginNode.elements().forEachRemaining(arg_0 -> CorsDeserializer.lambda$handleOrigin$0((Set)allowOrigin, allowOriginRegex, arg_0));
        }
    }

    private static void handleHeaders(JsonNode node, Cors cors) {
        JsonNode allowHeadersNode = node.get("allowHeaders");
        LinkedCaseInsensitiveSet allowHeaders = new LinkedCaseInsensitiveSet();
        cors.setAccessControlAllowHeaders((Set)allowHeaders);
        if (allowHeadersNode != null) {
            allowHeadersNode.elements().forEachRemaining(arg_0 -> CorsDeserializer.lambda$handleHeaders$1((Set)allowHeaders, arg_0));
        }
    }

    private static void handleMethods(JsonNode node, Cors cors) {
        JsonNode allowMethodsNode = node.get("allowMethods");
        LinkedHashSet allowMethods = new LinkedHashSet();
        cors.setAccessControlAllowMethods(allowMethods);
        if (allowMethodsNode != null) {
            allowMethodsNode.elements().forEachRemaining(jsonNode -> allowMethods.add(jsonNode.asText()));
        }
    }

    private static void handleExposeHeaders(JsonNode node, Cors cors) {
        JsonNode exposeHeadersNode = node.get("exposeHeaders");
        LinkedCaseInsensitiveSet exposeHeaders = new LinkedCaseInsensitiveSet();
        cors.setAccessControlExposeHeaders((Set)exposeHeaders);
        if (exposeHeadersNode != null) {
            exposeHeadersNode.elements().forEachRemaining(arg_0 -> CorsDeserializer.lambda$handleExposeHeaders$3((Set)exposeHeaders, arg_0));
        }
    }

    private static /* synthetic */ void lambda$handleExposeHeaders$3(Set exposeHeaders, JsonNode jsonNode) {
        exposeHeaders.add(jsonNode.asText());
    }

    private static /* synthetic */ void lambda$handleHeaders$1(Set allowHeaders, JsonNode jsonNode) {
        allowHeaders.add(jsonNode.asText());
    }

    private static /* synthetic */ void lambda$handleOrigin$0(Set allowOrigin, Set allowOriginRegex, JsonNode jsonNode) {
        allowOrigin.add(jsonNode.asText());
        if (!"*".equals(jsonNode.asText()) && (jsonNode.asText().contains("(") || jsonNode.asText().contains("[") || jsonNode.asText().contains("*"))) {
            try {
                allowOriginRegex.add(Pattern.compile(jsonNode.asText()));
            }
            catch (PatternSyntaxException pse) {
                log.error("Allow origin regex invalid: {} {}", (Object)jsonNode.asText(), (Object)pse.getMessage());
            }
        }
    }
}

