/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.flow.Consumer;
import io.gravitee.definition.model.flow.ConsumerType;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerDeserializer
extends StdScalarDeserializer<Consumer> {
    private final Logger logger = LoggerFactory.getLogger(ConsumerDeserializer.class);

    public ConsumerDeserializer(Class<Consumer> vc) {
        super(vc);
    }

    public Consumer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Consumer consumer = new Consumer();
        consumer.setConsumerType(ConsumerType.valueOf((String)node.path("consumerType").asText(ConsumerType.TAG.name())));
        JsonNode consumerIdNode = node.get("consumerId");
        if (consumerIdNode == null) {
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)"Consumer ID property is required");
        }
        consumer.setConsumerId(consumerIdNode.asText());
        return consumer;
    }
}

