/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.DefinitionContext;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.definition.model.ExecutionMode;
import io.gravitee.definition.model.FlowMode;
import io.gravitee.definition.model.PathMapping;
import io.gravitee.definition.model.Plan;
import io.gravitee.definition.model.Properties;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.Service;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.FlowStage;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.definition.model.services.Services;
import io.gravitee.definition.model.services.discovery.EndpointDiscoveryService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiDeserializer<T extends Api>
extends StdScalarDeserializer<T> {
    private final Logger logger = LoggerFactory.getLogger(ApiDeserializer.class);

    public ApiDeserializer(Class<T> vc) {
        super(vc);
    }

    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        return (T)this.deserialize(jp, ctxt, new Api(), node);
    }

    public T deserialize(JsonParser jp, DeserializationContext ctxt, T api, JsonNode node) throws IOException {
        JsonNode definitionContextNode;
        JsonNode responseTemplatesNode;
        JsonNode pathMappingsNode;
        JsonNode tagsNode;
        JsonNode propertiesNode;
        JsonNode resourcesNode;
        EndpointDiscoveryService discoveryService;
        JsonNode idNode = node.get("id");
        if (idNode == null) {
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)"ID property is required");
        }
        api.setId(idNode.asText());
        JsonNode nameNode = node.get("name");
        if (nameNode == null) {
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)"Name property is required");
        }
        api.setName(nameNode.asText());
        api.setDefinitionVersion(ApiDeserializer.foundDefinitionVersion(node));
        JsonNode versionNode = node.get("version");
        if (versionNode == null) {
            api.setVersion("undefined");
        } else {
            api.setVersion(versionNode.asText());
        }
        api.setExecutionMode(ExecutionMode.fromLabel((String)node.path("execution_mode").asText()));
        JsonNode proxyNode = node.get("proxy");
        if (proxyNode != null) {
            api.setProxy((Proxy)proxyNode.traverse(jp.getCodec()).readValueAs(Proxy.class));
        } else if (api.getDefinitionVersion() == DefinitionVersion.V2) {
            this.logger.error("A proxy property is required for {}", (Object)api.getName());
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)("A proxy property is required for " + api.getName()));
        }
        JsonNode servicesNode = node.get("services");
        if (servicesNode != null) {
            Services services = (Services)servicesNode.traverse(jp.getCodec()).readValueAs(Services.class);
            api.getServices().set(services.getAll());
        }
        if (api.getServices() != null && (discoveryService = (EndpointDiscoveryService)api.getServices().get(EndpointDiscoveryService.class)) != null) {
            api.getServices().remove(EndpointDiscoveryService.class);
            Set endpointGroups = api.getProxy().getGroups();
            if (endpointGroups != null && !endpointGroups.isEmpty()) {
                EndpointGroup defaultGroup = (EndpointGroup)endpointGroups.iterator().next();
                defaultGroup.getServices().put(EndpointDiscoveryService.class, (Service)discoveryService);
            }
        }
        if ((resourcesNode = node.get("resources")) != null && resourcesNode.isArray()) {
            resourcesNode.elements().forEachRemaining(resourceNode -> {
                try {
                    Resource resource = (Resource)resourceNode.traverse(jp.getCodec()).readValueAs(Resource.class);
                    if (api.getResources().contains(resource)) {
                        throw JsonMappingException.from((DeserializationContext)ctxt, (String)("A resource already exists with name " + resource.getName()));
                    }
                    api.getResources().add(resource);
                }
                catch (IOException e) {
                    this.logger.error("An error occurred during api deserialization", (Throwable)e);
                }
            });
        }
        api.setFlowMode(FlowMode.valueOf((String)node.path("flow_mode").asText(FlowMode.DEFAULT.name())));
        if (api.getDefinitionVersion() == DefinitionVersion.V1) {
            if (node.get("flows") != null) {
                throw JsonMappingException.from((DeserializationContext)ctxt, (String)"Flows are only available for definition >= 2.x.x ");
            }
            JsonNode pathsNode = node.get("paths");
            if (pathsNode != null) {
                TreeMap paths = new TreeMap(Comparator.reverseOrder());
                pathsNode.fields().forEachRemaining(jsonNode -> {
                    try {
                        List rules = (List)((JsonNode)jsonNode.getValue()).traverse(jp.getCodec()).readValueAs((TypeReference)new TypeReference<List<Rule>>(this){});
                        paths.put((String)jsonNode.getKey(), rules);
                    }
                    catch (IOException e) {
                        this.logger.error("Path {} cannot be de-serialized", jsonNode.getKey());
                    }
                });
                api.setPaths(paths);
            }
        }
        if (api.getDefinitionVersion() == DefinitionVersion.V2) {
            JsonNode plansNode;
            if (node.get("paths") != null) {
                throw JsonMappingException.from((DeserializationContext)ctxt, (String)"Paths are only available for definition 1.x.x ");
            }
            JsonNode flowsNode = node.get("flows");
            if (flowsNode != null) {
                ArrayList flows = new ArrayList();
                flowsNode.elements().forEachRemaining(jsonNode -> {
                    try {
                        Flow flow = (Flow)jsonNode.traverse(jp.getCodec()).readValueAs(Flow.class);
                        flow.setStage(FlowStage.API);
                        flows.add(flow);
                    }
                    catch (IOException e) {
                        this.logger.error("Flow {} cannot be de-serialized", (Object)jsonNode.asText());
                    }
                });
                api.setFlows(flows);
            }
            if ((plansNode = node.get("plans")) != null) {
                ArrayList plans = new ArrayList();
                plansNode.elements().forEachRemaining(jsonNode -> {
                    try {
                        Plan plan = (Plan)jsonNode.traverse(jp.getCodec()).readValueAs(Plan.class);
                        plan.getFlows().forEach(flow -> flow.setStage(FlowStage.PLAN));
                        if (plan.getApi() == null) {
                            plan.setApi(api.getId());
                        }
                        plans.add(plan);
                    }
                    catch (IOException e) {
                        this.logger.error("Plan {} cannot be de-serialized", (Object)jsonNode.asText());
                    }
                });
                api.setPlans(plans);
            }
        }
        if ((propertiesNode = node.get("properties")) != null) {
            Properties properties = (Properties)propertiesNode.traverse(jp.getCodec()).readValueAs(Properties.class);
            api.setProperties(properties);
        }
        if ((tagsNode = node.get("tags")) != null && tagsNode.isArray()) {
            tagsNode.elements().forEachRemaining(jsonNode -> api.getTags().add(jsonNode.asText()));
        }
        if ((pathMappingsNode = node.get("path_mappings")) != null) {
            pathMappingsNode.elements().forEachRemaining(jsonNode -> {
                String pathMapping = jsonNode.asText();
                api.getPathMappings().put(pathMapping, PathMapping.buildPattern((String)pathMapping));
            });
        }
        if ((responseTemplatesNode = node.get("response_templates")) != null) {
            HashMap responseTemplates = new HashMap();
            responseTemplatesNode.fields().forEachRemaining(jsonNode -> {
                try {
                    Map templates = (Map)((JsonNode)jsonNode.getValue()).traverse(jp.getCodec()).readValueAs((TypeReference)new TypeReference<Map<String, ResponseTemplate>>(this){});
                    responseTemplates.put((String)jsonNode.getKey(), templates);
                }
                catch (IOException e) {
                    this.logger.error("Response templates {} cannot be de-serialized", jsonNode.getKey());
                }
            });
            api.setResponseTemplates(responseTemplates);
        }
        if ((definitionContextNode = node.get("definition_context")) != null) {
            DefinitionContext definitionContext = (DefinitionContext)definitionContextNode.traverse(jp.getCodec()).readValueAs(DefinitionContext.class);
            api.setDefinitionContext(definitionContext);
        }
        return api;
    }

    private static DefinitionVersion foundDefinitionVersion(JsonNode node) {
        try {
            if (node.hasNonNull("definitionVersion")) {
                JsonNode definitionVersion = node.get("definitionVersion");
                return DefinitionVersion.valueOf((String)definitionVersion.asText());
            }
        }
        catch (IllegalArgumentException definitionVersion) {
            // empty catch block
        }
        try {
            if (node.hasNonNull("gravitee")) {
                JsonNode gravitee = node.get("gravitee");
                return DefinitionVersion.valueOfLabel((String)gravitee.asText());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return DefinitionVersion.V1;
    }
}

