/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.services.healthcheck.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.services.healthcheck.HealthCheckRequest;
import io.gravitee.definition.model.services.healthcheck.HealthCheckResponse;
import io.gravitee.definition.model.services.healthcheck.HealthCheckStep;
import java.io.IOException;
import java.util.Collections;

public class StepDeserializer
extends StdScalarDeserializer<HealthCheckStep> {
    public StepDeserializer(Class<HealthCheckStep> vc) {
        super(vc);
    }

    public HealthCheckStep deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        HealthCheckStep step = new HealthCheckStep();
        JsonNode requestNode = node.get("request");
        if (requestNode == null) {
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)"[health-check] Step request is required");
        }
        step.setRequest((HealthCheckRequest)requestNode.traverse(jsonParser.getCodec()).readValueAs(HealthCheckRequest.class));
        JsonNode responseNode = node.get("response");
        if (responseNode != null) {
            step.setResponse((HealthCheckResponse)responseNode.traverse(jsonParser.getCodec()).readValueAs(HealthCheckResponse.class));
        } else {
            HealthCheckResponse response = new HealthCheckResponse();
            response.setAssertions(Collections.singletonList("#response.status == 200"));
            step.setResponse(response);
        }
        JsonNode nameNode = node.get("name");
        if (nameNode != null) {
            step.setName(nameNode.asText());
        } else {
            step.setName("default-step");
        }
        return step;
    }
}

