/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.services.discovery.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.definition.jackson.datatype.services.core.deser.ServiceDeserializer;
import io.gravitee.definition.jackson.datatype.services.discovery.EndpointDiscoveryProviderMapper;
import io.gravitee.definition.model.services.discovery.EndpointDiscoveryService;
import java.io.IOException;

public class EndpointDiscoveryDeserializer
extends ServiceDeserializer<EndpointDiscoveryService> {
    public EndpointDiscoveryDeserializer(Class<EndpointDiscoveryService> vc) {
        super(vc);
    }

    @Override
    protected void deserialize(EndpointDiscoveryService service, JsonParser jsonParser, JsonNode node, DeserializationContext ctxt) throws IOException {
        super.deserialize(service, jsonParser, node, ctxt);
        if (service.isEnabled()) {
            JsonNode providerNode = node.get("provider");
            if (providerNode == null) {
                throw JsonMappingException.from((DeserializationContext)ctxt, (String)"[endpoint-discovery] Provider is required");
            }
            String provider = providerNode.asText().toUpperCase();
            String providerPlugin = EndpointDiscoveryProviderMapper.getProvider(provider);
            service.setProvider(providerPlugin);
            service.setConfiguration((Object)node.get("configuration").toString());
        }
    }
}

