/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.services.core.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.definition.jackson.datatype.services.core.deser.ServiceDeserializer;
import io.gravitee.definition.model.services.schedule.ScheduledService;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class ScheduledServiceDeserializer<T extends ScheduledService>
extends ServiceDeserializer<T> {
    public ScheduledServiceDeserializer(Class<T> vc) {
        super(vc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void deserialize(T service, JsonParser jsonParser, JsonNode node, DeserializationContext ctxt) throws IOException {
        String schedule;
        super.deserialize(service, jsonParser, node, ctxt);
        JsonNode scheduleNode = node.get("schedule");
        if (scheduleNode != null) {
            schedule = scheduleNode.asText();
        } else {
            JsonNode intervalNode;
            Long rate = null;
            TimeUnit unit = null;
            if (node.has("trigger")) {
                JsonNode triggerNode = node.get("trigger");
                JsonNode rateNode = triggerNode.get("rate");
                if (rateNode == null) {
                    throw JsonMappingException.from((DeserializationContext)ctxt, (String)"[scheduled-service] Rate is required");
                }
                rate = rateNode.asLong();
                JsonNode unitNode = triggerNode.get("unit");
                if (unitNode == null) throw JsonMappingException.from((DeserializationContext)ctxt, (String)"[scheduled-service] Unit is required");
                unit = TimeUnit.valueOf(unitNode.asText().toUpperCase());
            } else if (node.has("interval") && (intervalNode = node.get("interval")) != null) {
                rate = intervalNode.asLong();
                JsonNode unitNode = node.get("unit");
                if (unitNode == null) throw JsonMappingException.from((DeserializationContext)ctxt, (String)"[scheduled-service] Unit is required");
                unit = TimeUnit.valueOf(unitNode.asText().toUpperCase());
            }
            schedule = ScheduledServiceDeserializer.convertToCron(rate, unit);
        }
        service.setSchedule(schedule);
    }

    public static String convertToCron(Long rate, TimeUnit unit) {
        if (rate == null || unit == null) {
            return null;
        }
        List<String> scheduleList = Arrays.asList("*", "*", "*", "*", "*", "*");
        List<TimeUnit> timeUnits = Arrays.asList(TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS, TimeUnit.DAYS);
        int index = timeUnits.indexOf((Object)unit);
        for (int i = 0; i < index; ++i) {
            scheduleList.set(i, "0");
        }
        scheduleList.set(index, "*/" + rate);
        String schedule = String.join((CharSequence)" ", scheduleList);
        return schedule;
    }
}

