/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.definition.jackson.datatype.api.deser.AbstractStdScalarDeserializer;
import io.gravitee.definition.model.HttpClientSslOptions;
import io.gravitee.definition.model.ssl.KeyStore;
import io.gravitee.definition.model.ssl.KeyStoreType;
import io.gravitee.definition.model.ssl.TrustStore;
import io.gravitee.definition.model.ssl.TrustStoreType;
import io.gravitee.definition.model.ssl.jks.JKSKeyStore;
import io.gravitee.definition.model.ssl.jks.JKSTrustStore;
import io.gravitee.definition.model.ssl.pem.PEMKeyStore;
import io.gravitee.definition.model.ssl.pem.PEMTrustStore;
import io.gravitee.definition.model.ssl.pkcs12.PKCS12KeyStore;
import io.gravitee.definition.model.ssl.pkcs12.PKCS12TrustStore;
import java.io.IOException;

public class HttpClientSslOptionsDeserializer
extends AbstractStdScalarDeserializer<HttpClientSslOptions> {
    public HttpClientSslOptionsDeserializer(Class<HttpClientSslOptions> vc) {
        super(vc);
    }

    public HttpClientSslOptions deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode keyStoreNode;
        JsonNode trustStoreNode;
        String sPem;
        JsonNode hostnameVerifierNode;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        HttpClientSslOptions httpClientSslOptions = new HttpClientSslOptions();
        JsonNode trustAllNode = node.get("trustAll");
        if (trustAllNode != null) {
            boolean trustAll = trustAllNode.asBoolean(false);
            httpClientSslOptions.setTrustAll(trustAll);
        }
        if ((hostnameVerifierNode = node.get("hostnameVerifier")) != null) {
            boolean hostnameVerifier = hostnameVerifierNode.asBoolean(false);
            httpClientSslOptions.setHostnameVerifier(hostnameVerifier);
        }
        if ((sPem = this.readStringValue(node, "pem")) != null && !sPem.equals("null")) {
            PEMTrustStore trustStore = new PEMTrustStore();
            trustStore.setContent(sPem);
            httpClientSslOptions.setTrustStore((TrustStore)trustStore);
        }
        if ((trustStoreNode = node.get("trustStore")) != null) {
            try {
                TrustStoreType type = TrustStoreType.valueOf((String)trustStoreNode.path("type").asText().toUpperCase());
                TrustStore trustStore = null;
                switch (type) {
                    case JKS: {
                        trustStore = (TrustStore)trustStoreNode.traverse(jp.getCodec()).readValueAs(JKSTrustStore.class);
                        break;
                    }
                    case PEM: {
                        trustStore = (TrustStore)trustStoreNode.traverse(jp.getCodec()).readValueAs(PEMTrustStore.class);
                        break;
                    }
                    case PKCS12: {
                        trustStore = (TrustStore)trustStoreNode.traverse(jp.getCodec()).readValueAs(PKCS12TrustStore.class);
                    }
                }
                httpClientSslOptions.setTrustStore(trustStore);
            }
            catch (IllegalArgumentException type) {
                // empty catch block
            }
        }
        if ((keyStoreNode = node.get("keyStore")) != null) {
            try {
                KeyStoreType type = KeyStoreType.valueOf((String)keyStoreNode.path("type").asText().toUpperCase());
                KeyStore keyStore = null;
                switch (type) {
                    case JKS: {
                        keyStore = (KeyStore)keyStoreNode.traverse(jp.getCodec()).readValueAs(JKSKeyStore.class);
                        break;
                    }
                    case PEM: {
                        keyStore = (KeyStore)keyStoreNode.traverse(jp.getCodec()).readValueAs(PEMKeyStore.class);
                        break;
                    }
                    case PKCS12: {
                        keyStore = (KeyStore)keyStoreNode.traverse(jp.getCodec()).readValueAs(PKCS12KeyStore.class);
                    }
                }
                httpClientSslOptions.setKeyStore(keyStore);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return httpClientSslOptions;
    }
}

