/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.common.util.LinkedCaseInsensitiveSet;
import io.gravitee.definition.model.Cors;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorsDeserializer
extends StdScalarDeserializer<Cors> {
    private final Logger logger = LoggerFactory.getLogger(CorsDeserializer.class);

    public CorsDeserializer(Class<Cors> vc) {
        super(vc);
    }

    public Cors deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Cors cors = new Cors();
        JsonNode enabledNode = node.get("enabled");
        if (enabledNode != null) {
            boolean enabled = enabledNode.asBoolean(false);
            cors.setEnabled(enabled);
        }
        if (cors.isEnabled()) {
            JsonNode maxAgeNode;
            JsonNode allowCredentialsNode = node.get("allowCredentials");
            if (allowCredentialsNode != null) {
                boolean allowCredentials = allowCredentialsNode.asBoolean(false);
                cors.setAccessControlAllowCredentials(allowCredentials);
            } else {
                cors.setAccessControlAllowCredentials(false);
            }
            JsonNode allowOriginNode = node.get("allowOrigin");
            LinkedCaseInsensitiveSet allowOrigin = new LinkedCaseInsensitiveSet();
            HashSet allowOriginRegex = new HashSet();
            cors.setAccessControlAllowOrigin((Set)allowOrigin);
            cors.setAccessControlAllowOriginRegex(allowOriginRegex);
            if (allowOriginNode != null) {
                allowOriginNode.elements().forEachRemaining(arg_0 -> this.lambda$deserialize$0((Set)allowOrigin, allowOriginRegex, arg_0));
            }
            JsonNode allowHeadersNode = node.get("allowHeaders");
            LinkedCaseInsensitiveSet allowHeaders = new LinkedCaseInsensitiveSet();
            cors.setAccessControlAllowHeaders((Set)allowHeaders);
            if (allowHeadersNode != null) {
                allowHeadersNode.elements().forEachRemaining(arg_0 -> CorsDeserializer.lambda$deserialize$1((Set)allowHeaders, arg_0));
            }
            JsonNode allowMethodsNode = node.get("allowMethods");
            HashSet allowMethods = new HashSet();
            cors.setAccessControlAllowMethods(allowMethods);
            if (allowMethodsNode != null) {
                allowMethodsNode.elements().forEachRemaining(jsonNode -> allowMethods.add(jsonNode.asText()));
            }
            JsonNode exposeHeadersNode = node.get("exposeHeaders");
            LinkedCaseInsensitiveSet exposeHeaders = new LinkedCaseInsensitiveSet();
            cors.setAccessControlExposeHeaders((Set)exposeHeaders);
            if (exposeHeadersNode != null) {
                exposeHeadersNode.elements().forEachRemaining(arg_0 -> CorsDeserializer.lambda$deserialize$3((Set)exposeHeaders, arg_0));
            }
            if ((maxAgeNode = node.get("maxAge")) != null) {
                cors.setAccessControlMaxAge(maxAgeNode.asInt(-1));
            } else {
                cors.setAccessControlMaxAge(-1);
            }
            cors.setRunPolicies(node.path("runPolicies").asBoolean(false));
        }
        return cors;
    }

    private static /* synthetic */ void lambda$deserialize$3(Set exposeHeaders, JsonNode jsonNode) {
        exposeHeaders.add(jsonNode.asText());
    }

    private static /* synthetic */ void lambda$deserialize$1(Set allowHeaders, JsonNode jsonNode) {
        allowHeaders.add(jsonNode.asText());
    }

    private /* synthetic */ void lambda$deserialize$0(Set allowOrigin, Set allowOriginRegex, JsonNode jsonNode) {
        allowOrigin.add(jsonNode.asText());
        if (!"*".equals(jsonNode.asText()) && (jsonNode.asText().contains("(") || jsonNode.asText().contains("[") || jsonNode.asText().contains("*"))) {
            try {
                allowOriginRegex.add(Pattern.compile(jsonNode.asText()));
            }
            catch (PatternSyntaxException pse) {
                this.logger.error("Allow origin regex invalid: " + jsonNode.asText(), (Object)pse.getMessage());
            }
        }
    }
}

