/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.services.healthcheck.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.common.http.HttpHeader;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.services.healthcheck.HealthCheckRequest;
import java.io.IOException;
import java.util.ArrayList;

public class RequestDeserializer
extends StdScalarDeserializer<HealthCheckRequest> {
    public RequestDeserializer(Class<HealthCheckRequest> vc) {
        super(vc);
    }

    public HealthCheckRequest deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode headersNode;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        HealthCheckRequest request = new HealthCheckRequest();
        JsonNode pathNode = node.get("path");
        if (pathNode != null) {
            request.setPath(pathNode.asText());
        } else {
            JsonNode uriNode = node.get("uri");
            if (uriNode != null) {
                request.setPath(uriNode.asText());
            } else {
                throw ctxt.mappingException("[healthcheck] URI is required");
            }
        }
        JsonNode methodNode = node.get("method");
        if (methodNode == null) {
            throw ctxt.mappingException("[healthcheck] Method is required");
        }
        request.setMethod(HttpMethod.valueOf((String)methodNode.asText().toUpperCase()));
        JsonNode bodyNode = node.get("body");
        if (bodyNode != null) {
            request.setBody(bodyNode.asText());
        }
        if ((headersNode = node.get("headers")) != null) {
            ArrayList headers = new ArrayList();
            headersNode.elements().forEachRemaining(headerNode -> {
                HttpHeader header = new HttpHeader();
                header.setName(headerNode.findValue("name").asText());
                header.setValue(headerNode.findValue("value").asText());
                headers.add(header);
            });
            request.setHeaders(headers);
        }
        request.setFromRoot(node.path("fromRoot").asBoolean(false));
        return request;
    }
}

