/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.flow.Step;
import java.io.IOException;

public class StepDeserializer
extends StdScalarDeserializer<Step> {
    public StepDeserializer(Class<Step> vc) {
        super(vc);
    }

    public Step deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String conditionStr;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Step step = new Step();
        step.setName(node.path("name").asText());
        JsonNode description = node.path("description");
        if (!description.isMissingNode() && !description.isNull()) {
            step.setDescription(description.asText());
        }
        step.setPolicy(node.get("policy").asText());
        JsonNode condition = node.get("condition");
        if (!(condition == null || condition.isMissingNode() || condition.isNull() || (conditionStr = condition.asText()).isBlank())) {
            step.setCondition(conditionStr);
        }
        step.setConfiguration(node.get("configuration").toString());
        step.setEnabled(node.path("enabled").asBoolean(true));
        return step;
    }
}

