/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.Property;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PropertiesAsListDeserializer
extends StdScalarDeserializer<List<Property>> {
    public PropertiesAsListDeserializer() {
        super(List.class);
    }

    public List<Property> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        ArrayList<Property> values = new ArrayList<Property>();
        if (node.isArray()) {
            node.elements().forEachRemaining(jsonNode -> {
                try {
                    Property property = (Property)jsonNode.traverse(jp.getCodec()).readValueAs(Property.class);
                    values.add(property);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        } else if (node.isObject()) {
            node.fields().forEachRemaining(jsonNode -> values.add(new Property((String)jsonNode.getKey(), ((JsonNode)jsonNode.getValue()).asText())));
        }
        return values;
    }
}

