/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.node.TextNode;
import io.gravitee.definition.model.Logging;
import io.gravitee.definition.model.LoggingContent;
import io.gravitee.definition.model.LoggingMode;
import io.gravitee.definition.model.LoggingScope;
import java.io.IOException;

public class LoggingDeserializer
extends StdScalarDeserializer<Logging> {
    private static final JsonNode NULL = new TextNode("null");

    public LoggingDeserializer(Class<Logging> vc) {
        super(vc);
    }

    public Logging deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode condition;
        JsonNode scope;
        JsonNode content;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Logging logging = new Logging();
        JsonNode mode = node.get("mode");
        if (mode != null) {
            logging.setMode(LoggingMode.valueOf((String)mode.asText().toUpperCase()));
        }
        if ((content = node.get("content")) != null) {
            logging.setContent(LoggingContent.valueOf((String)content.asText().toUpperCase()));
        }
        if ((scope = node.get("scope")) != null) {
            logging.setScope(LoggingScope.valueOf((String)scope.asText().toUpperCase()));
        }
        if ((condition = node.get("condition")) != null && !NULL.equals((Object)condition)) {
            logging.setCondition(condition.asText());
        }
        return logging;
    }
}

