/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.common.http.HttpHeader;
import io.gravitee.definition.model.Endpoint;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.definition.model.HttpClientOptions;
import io.gravitee.definition.model.HttpClientSslOptions;
import io.gravitee.definition.model.HttpProxy;
import io.gravitee.definition.model.LoadBalancer;
import io.gravitee.definition.model.services.Services;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class EndpointGroupDeserializer
extends StdScalarDeserializer<EndpointGroup> {
    private static final String DEFAULT_GROUP_NAME = "default";

    public EndpointGroupDeserializer(Class<EndpointGroup> vc) {
        super(vc);
    }

    public EndpointGroup deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String hostHeader;
        JsonNode hostHeaderNode;
        JsonNode headersNode;
        JsonNode httpClientOptionsNode;
        JsonNode httpProxyNode;
        JsonNode servicesNode;
        JsonNode loadBalancingNode;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        EndpointGroup group = new EndpointGroup();
        group.setName(node.path("name").asText(DEFAULT_GROUP_NAME));
        JsonNode nodeEndpoints = node.get("endpoints");
        if (nodeEndpoints != null) {
            LinkedHashSet<Endpoint> endpoints = new LinkedHashSet<Endpoint>(nodeEndpoints.size());
            for (JsonNode jsonNode : nodeEndpoints) {
                boolean added;
                Endpoint endpoint = (Endpoint)jsonNode.traverse(jp.getCodec()).readValueAs(Endpoint.class);
                if (endpoint == null || (added = endpoints.add(endpoint))) continue;
                throw ctxt.mappingException("[api] API endpoint names must be unique");
            }
            group.setEndpoints(endpoints);
        }
        if ((loadBalancingNode = node.get("load_balancing")) != null) {
            LoadBalancer loadBalancer = (LoadBalancer)loadBalancingNode.traverse(jp.getCodec()).readValueAs(LoadBalancer.class);
            group.setLoadBalancer(loadBalancer);
        }
        if ((servicesNode = node.get("services")) != null) {
            Services services = (Services)servicesNode.traverse(jp.getCodec()).readValueAs(Services.class);
            group.getServices().set(services.getAll());
        }
        if ((httpProxyNode = node.get("proxy")) != null) {
            HttpProxy httpProxy = (HttpProxy)httpProxyNode.traverse(jp.getCodec()).readValueAs(HttpProxy.class);
            group.setHttpProxy(httpProxy);
        }
        if ((httpClientOptionsNode = node.get("http")) != null) {
            HttpClientOptions httpClientOptions = (HttpClientOptions)httpClientOptionsNode.traverse(jp.getCodec()).readValueAs(HttpClientOptions.class);
            group.setHttpClientOptions(httpClientOptions);
        } else {
            group.setHttpClientOptions(new HttpClientOptions());
        }
        JsonNode httpClientSslOptionsNode = node.get("ssl");
        if (httpClientSslOptionsNode != null) {
            HttpClientSslOptions httpClientSslOptions = (HttpClientSslOptions)httpClientSslOptionsNode.traverse(jp.getCodec()).readValueAs(HttpClientSslOptions.class);
            group.setHttpClientSslOptions(httpClientSslOptions);
        }
        if ((headersNode = node.get("headers")) != null && !headersNode.isEmpty(null)) {
            if (headersNode.isArray()) {
                headers = (List)headersNode.traverse(ctxt.getParser().getCodec()).readValueAs((TypeReference)new TypeReference<ArrayList<HttpHeader>>(){});
                group.setHeaders((List)headers);
            } else {
                headers = (Map)headersNode.traverse(ctxt.getParser().getCodec()).readValueAs((TypeReference)new TypeReference<HashMap<String, String>>(){});
                group.setHeaders(headers.entrySet().stream().map(entry -> new HttpHeader((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()));
            }
        }
        if ((hostHeaderNode = node.get("hostHeader")) != null && !(hostHeader = hostHeaderNode.asText()).trim().isEmpty()) {
            if (group.getHeaders() == null) {
                group.setHeaders(Collections.singletonList(new HttpHeader("Host", hostHeader)));
            } else {
                Optional<HttpHeader> first = group.getHeaders().stream().filter(httpHeader -> "Host".equals(httpHeader.getName())).findFirst();
                if (first.isPresent()) {
                    first.get().setValue(hostHeader);
                } else {
                    group.getHeaders().add(new HttpHeader("Host", hostHeader));
                }
            }
        }
        return group;
    }
}

