/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.ser.ssl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.gravitee.definition.model.ssl.TrustStore;
import java.io.IOException;

public abstract class TrustStoreSerializer<T extends TrustStore>
extends StdScalarSerializer<T> {
    public TrustStoreSerializer(Class<T> t) {
        super(t);
    }

    public void serialize(T trustStore, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        this.doSerialize(trustStore, jgen, provider);
        jgen.writeEndObject();
    }

    public void serializeWithType(T value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(value, g, provider);
    }

    protected void doSerialize(T trustStore, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
        jgen.writeStringField("type", trustStore.getType().name());
    }

    protected void writeStringField(JsonGenerator jgen, String field, String value) throws IOException {
        if (value != null && !value.isEmpty()) {
            jgen.writeStringField(field, value);
        }
    }
}

