/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.gravitee.definition.model.HttpClientOptions;
import io.gravitee.definition.model.ProtocolVersion;
import java.io.IOException;

public class HttpClientOptionsSerializer
extends StdScalarSerializer<HttpClientOptions> {
    public HttpClientOptionsSerializer(Class<HttpClientOptions> t) {
        super(t);
    }

    public void serialize(HttpClientOptions httpClientOptions, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeNumberField("connectTimeout", httpClientOptions.getConnectTimeout());
        jgen.writeNumberField("idleTimeout", httpClientOptions.getIdleTimeout());
        jgen.writeBooleanField("keepAlive", httpClientOptions.isKeepAlive());
        jgen.writeNumberField("readTimeout", httpClientOptions.getReadTimeout());
        jgen.writeBooleanField("pipelining", httpClientOptions.isPipelining());
        jgen.writeNumberField("maxConcurrentConnections", httpClientOptions.getMaxConcurrentConnections());
        jgen.writeBooleanField("useCompression", httpClientOptions.isUseCompression());
        if (!httpClientOptions.isUseCompression()) {
            jgen.writeBooleanField("propagateClientAcceptEncoding", httpClientOptions.isPropagateClientAcceptEncoding());
        }
        jgen.writeBooleanField("followRedirects", httpClientOptions.isFollowRedirects());
        if (httpClientOptions.getVersion() != ProtocolVersion.HTTP_1_1) {
            jgen.writeStringField("version", httpClientOptions.getVersion().name());
            jgen.writeBooleanField("clearTextUpgrade", httpClientOptions.isClearTextUpgrade());
        }
        jgen.writeEndObject();
    }
}

