/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.gravitee.definition.model.debug.DebugStep;
import java.io.IOException;
import java.util.Map;

public class DebugStepSerializer
extends StdScalarSerializer<DebugStep> {
    public DebugStepSerializer(Class<DebugStep> t) {
        super(t);
    }

    public void serialize(DebugStep debugStep, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (debugStep.getPolicyInstanceId() != null) {
            jgen.writeStringField("policyInstanceId", debugStep.getPolicyInstanceId());
        }
        if (debugStep.getPolicyId() != null) {
            jgen.writeStringField("policyId", debugStep.getPolicyId());
        }
        if (debugStep.getScope() != null) {
            jgen.writeStringField("scope", debugStep.getScope().name());
        }
        if (debugStep.getStatus() != null) {
            jgen.writeStringField("status", debugStep.getStatus().name());
        }
        if (debugStep.getCondition() != null) {
            jgen.writeStringField("condition", debugStep.getCondition());
        }
        if (debugStep.getError() != null) {
            jgen.writeObjectField("error", (Object)debugStep.getError());
        }
        if (debugStep.getDuration() != null) {
            jgen.writeNumberField("duration", debugStep.getDuration().longValue());
        }
        if (debugStep.getResult() != null) {
            jgen.writeObjectFieldStart("result");
            for (Map.Entry entry : debugStep.getResult().entrySet()) {
                jgen.writeObjectField((String)entry.getKey(), entry.getValue());
            }
            jgen.writeEndObject();
        }
        if (debugStep.getStage() != null) {
            jgen.writeStringField("stage", debugStep.getStage());
        }
        jgen.writeEndObject();
    }
}

