/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.HttpRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpRequestDeserializer
extends StdScalarDeserializer<HttpRequest> {
    public HttpRequestDeserializer(Class<HttpRequest> vc) {
        super(vc);
    }

    public HttpRequest deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setPath(this.readStringValue(node, "path"));
        httpRequest.setMethod(this.readStringValue(node, "method"));
        httpRequest.setBody(this.readStringValue(node, "body"));
        JsonNode headersNode = node.get("headers");
        if (headersNode != null && !headersNode.isEmpty(null)) {
            httpRequest.setHeaders((Map)headersNode.traverse(jp.getCodec()).readValueAs((TypeReference)new TypeReference<HashMap<String, List<String>>>(){}));
        }
        return httpRequest;
    }

    private String readStringValue(JsonNode rootNode, String fieldName) {
        JsonNode fieldNode = rootNode.get(fieldName);
        if (fieldNode != null) {
            return fieldNode.asText();
        }
        return null;
    }
}

