/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.flow.Consumer;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.PathOperator;
import io.gravitee.definition.model.flow.Step;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;

public class FlowDeserializer
extends StdScalarDeserializer<Flow> {
    public FlowDeserializer(Class<Flow> vc) {
        super(vc);
    }

    public Flow deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode postNode;
        JsonNode preNode;
        JsonNode methodsNode;
        JsonNode consumersNode;
        JsonNode condition;
        JsonNode name;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Flow flow = new Flow();
        JsonNode jsonId = node.path("id");
        if (!jsonId.isNull() && !jsonId.asText().isEmpty()) {
            flow.setId(jsonId.asText());
        }
        if (!(name = node.path("name")).isNull() && !name.isMissingNode()) {
            flow.setName(name.asText());
        }
        flow.setEnabled(node.path("enabled").asBoolean(true));
        JsonNode jsonPathOperator = node.get("path-operator");
        if (jsonPathOperator != null) {
            flow.setPathOperator((PathOperator)jsonPathOperator.traverse(jp.getCodec()).readValueAs(PathOperator.class));
        }
        if (!(condition = node.path("condition")).isNull() && !condition.isMissingNode()) {
            flow.setCondition(condition.asText());
        }
        if ((consumersNode = node.get("consumers")) != null && consumersNode.isArray()) {
            ArrayList consumers = new ArrayList();
            consumersNode.elements().forEachRemaining(jsonNode -> {
                try {
                    consumers.add((Consumer)jsonNode.traverse(jp.getCodec()).readValueAs(Consumer.class));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            flow.setConsumers(consumers);
        }
        if ((methodsNode = node.get("methods")) != null && methodsNode.isArray()) {
            EnumSet<HttpMethod> methods = EnumSet.noneOf(HttpMethod.class);
            methodsNode.elements().forEachRemaining(jsonNode -> methods.add(HttpMethod.valueOf((String)jsonNode.asText().toUpperCase())));
            flow.setMethods(methods);
        }
        if ((preNode = node.get("pre")) != null && preNode.isArray()) {
            ArrayList steps = new ArrayList();
            preNode.elements().forEachRemaining(jsonNode -> {
                try {
                    steps.add((Step)jsonNode.traverse(jp.getCodec()).readValueAs(Step.class));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            flow.setPre(steps);
        }
        if ((postNode = node.get("post")) != null && postNode.isArray()) {
            ArrayList steps = new ArrayList();
            postNode.elements().forEachRemaining(jsonNode -> {
                try {
                    steps.add((Step)jsonNode.traverse(jp.getCodec()).readValueAs(Step.class));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            flow.setPost(steps);
        }
        return flow;
    }
}

