/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.definition.jackson.datatype.GraviteeMapper;
import io.gravitee.definition.model.Endpoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EndpointDeserializer
extends StdScalarDeserializer<Endpoint> {
    private final GraviteeMapper mapper;

    public EndpointDeserializer(Class<Endpoint> vc, GraviteeMapper mapper) {
        super(vc);
        this.mapper = mapper;
    }

    public Endpoint deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonNode inheritNode;
        String pemValue;
        JsonNode pemNode;
        JsonNode sslNode;
        JsonNode hostHeaderNode;
        JsonNode headersNode;
        JsonNode healthcheckNode;
        JsonNode tenantsNode;
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        JsonNode nameNode = node.get("name");
        if (nameNode == null) {
            throw ctxt.mappingException("Endpoint name is required");
        }
        String name = nameNode.asText();
        JsonNode targetNode = node.get("target");
        if (targetNode == null) {
            throw ctxt.mappingException("Endpoint target is required");
        }
        String target = targetNode.asText();
        JsonNode typeNode = node.get("type");
        Endpoint endpoint = new Endpoint(typeNode != null ? typeNode.asText() : null, name, target);
        JsonNode weightNode = node.get("weight");
        if (weightNode != null) {
            int weight = weightNode.asInt(1);
            endpoint.setWeight(weight);
        } else {
            endpoint.setWeight(1);
        }
        JsonNode backupNode = node.get("backup");
        if (backupNode != null) {
            boolean backup = backupNode.asBoolean(false);
            endpoint.setBackup(backup);
        } else {
            endpoint.setBackup(false);
        }
        JsonNode singleTenantNode = node.get("tenant");
        if (singleTenantNode != null) {
            String tenant = singleTenantNode.asText();
            endpoint.setTenants(Collections.singletonList(tenant));
        }
        if ((tenantsNode = node.get("tenants")) != null && tenantsNode.isArray()) {
            ArrayList tenants = new ArrayList(tenantsNode.size());
            tenantsNode.elements().forEachRemaining(tenantNode -> tenants.add(tenantNode.asText()));
            endpoint.setTenants(tenants);
        }
        if ((healthcheckNode = node.get("healthcheck")) != null && !healthcheckNode.isObject()) {
            ((ObjectNode)node).remove("healthcheck");
        }
        if ((headersNode = node.get("headers")) != null && !headersNode.isEmpty(null) && headersNode.isObject()) {
            Map headers = (Map)headersNode.traverse(ctxt.getParser().getCodec()).readValueAs((TypeReference)new TypeReference<HashMap<String, String>>(){});
            ArrayNode headersUpdated = this.mapper.createArrayNode();
            headers.keySet().forEach(key -> {
                ObjectNode objectNode = this.mapper.createObjectNode();
                objectNode.put("name", key);
                objectNode.put("value", (String)headers.get(key));
                headersUpdated.add((JsonNode)objectNode);
            });
            ((ObjectNode)node).set("headers", (JsonNode)headersUpdated);
        }
        if ((hostHeaderNode = node.get("hostHeader")) != null) {
            String hostHeader = hostHeaderNode.asText();
            if (!hostHeader.trim().isEmpty()) {
                headersNode = node.get("headers");
                if (headersNode == null) {
                    headersNode = this.mapper.createArrayNode();
                    ((ObjectNode)node).set("headers", headersNode);
                }
                ObjectNode hh = this.mapper.createObjectNode();
                hh.put("name", "Host");
                hh.put("value", hostHeader);
                ((ArrayNode)headersNode).add((JsonNode)hh);
            }
            ((ObjectNode)node).remove("hostHeader");
        }
        if ((sslNode = node.get("ssl")) != null && (pemNode = sslNode.get("pem")) != null && (pemValue = pemNode.asText()) != null && !pemValue.equals("null")) {
            ObjectNode truststoreNode = this.mapper.createObjectNode();
            truststoreNode.put("type", "PEM");
            truststoreNode.put("content", pemValue);
            ((ObjectNode)sslNode).set("trustStore", (JsonNode)truststoreNode);
            ((ObjectNode)sslNode).remove("pem");
        }
        if ((inheritNode = node.get("inherit")) != null) {
            endpoint.setInherit(Boolean.valueOf(inheritNode.asBoolean()));
        }
        endpoint.setConfiguration(node.toString());
        return endpoint;
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(p, ctxt);
    }
}

