/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.debug.DebugMetrics;
import java.io.IOException;

public class DebugMetricsDeserializer
extends StdScalarDeserializer<DebugMetrics> {
    public DebugMetricsDeserializer(Class<DebugMetrics> vc) {
        super(vc);
    }

    public DebugMetrics deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        DebugMetrics debugMetrics = new DebugMetrics();
        if (node.has("proxyLatencyMs")) {
            debugMetrics.setProxyLatencyMs(node.get("proxyLatencyMs").asLong());
        }
        if (node.has("apiResponseTimeMs")) {
            debugMetrics.setApiResponseTimeMs(node.get("apiResponseTimeMs").asLong());
        }
        if (node.has("proxyResponseTimeMs")) {
            debugMetrics.setProxyResponseTimeMs(node.get("proxyResponseTimeMs").asLong());
        }
        return debugMetrics;
    }
}

