/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.services.core.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.Service;
import io.gravitee.definition.model.services.Services;
import io.gravitee.definition.model.services.discovery.EndpointDiscoveryService;
import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyService;
import io.gravitee.definition.model.services.healthcheck.HealthCheckService;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ServicesDeserializer
extends StdScalarDeserializer<Services> {
    private final Map<String, Class<? extends Service>> registeredServices = new HashMap<String, Class<? extends Service>>();

    public ServicesDeserializer(Class<Services> vc) {
        super(vc);
        this.registeredServices.put("health-check", HealthCheckService.class);
        this.registeredServices.put("dynamic-property", DynamicPropertyService.class);
        this.registeredServices.put("discovery", EndpointDiscoveryService.class);
    }

    public Services deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Services services = new Services();
        ArrayList<Service> individualServices = new ArrayList<Service>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            try {
                Service service;
                String serviceType = (String)fieldNames.next();
                JsonNode serviceNode = node.findValue(serviceType);
                final Class<? extends Service> serviceClass = this.registeredServices.get(serviceType);
                if (serviceClass == null || (service = (Service)serviceNode.traverse(jp.getCodec()).readValueAs((TypeReference)new TypeReference<Service>(){

                    public Type getType() {
                        return serviceClass;
                    }
                })) == null) continue;
                individualServices.add(service);
            }
            catch (IOException ioe) {
                throw ctxt.mappingException(ioe.getMessage());
            }
        }
        services.set(individualServices);
        return services;
    }
}

