/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.PathOperator;
import io.gravitee.definition.model.flow.Step;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;

public class FlowSerializer
extends StdScalarSerializer<Flow> {
    public FlowSerializer(Class<Flow> vc) {
        super(vc);
    }

    public void serialize(Flow flow, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("id", flow.getId());
        jgen.writeStringField("name", flow.getName());
        PathOperator pathOperator = flow.getPathOperator();
        if (pathOperator != null) {
            jgen.writeObjectField("path-operator", (Object)pathOperator);
        }
        jgen.writeStringField("condition", flow.getCondition());
        jgen.writeArrayFieldStart("consumers");
        if (flow.getConsumers() != null) {
            for (Object consumer : flow.getConsumers()) {
                jgen.writeObject(consumer);
            }
        }
        jgen.writeEndArray();
        jgen.writeArrayFieldStart("methods");
        if (flow.getMethods() != null) {
            ArrayList<HttpMethod> sortedMethods = new ArrayList<HttpMethod>(flow.getMethods());
            sortedMethods.sort(Comparator.comparing(Enum::name));
            for (HttpMethod method : sortedMethods) {
                jgen.writeString(method.toString().toUpperCase());
            }
        }
        jgen.writeEndArray();
        jgen.writeArrayFieldStart("pre");
        for (Step step : flow.getPre()) {
            jgen.writeObject((Object)step);
        }
        jgen.writeEndArray();
        jgen.writeArrayFieldStart("post");
        for (Step step : flow.getPost()) {
            jgen.writeObject((Object)step);
        }
        jgen.writeEndArray();
        jgen.writeBooleanField("enabled", flow.isEnabled());
        jgen.writeEndObject();
    }
}

