/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.ser.endpoint;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.gravitee.definition.jackson.datatype.api.ser.EndpointSerializer;
import io.gravitee.definition.model.HttpClientOptions;
import io.gravitee.definition.model.endpoint.HttpEndpoint;
import java.io.IOException;

public class HttpEndpointSerializer<T extends HttpEndpoint>
extends EndpointSerializer<T> {
    public HttpEndpointSerializer(Class<T> t) {
        super(t);
    }

    @Override
    protected void doSerialize(T endpoint, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
        super.doSerialize(endpoint, jgen, serializerProvider);
        if (endpoint.getHealthCheck() != null) {
            jgen.writeObjectField("healthcheck", (Object)endpoint.getHealthCheck());
        }
        if (endpoint.getTenants() != null) {
            jgen.writeArrayFieldStart("tenants");
            endpoint.getTenants().forEach(tenant -> {
                try {
                    jgen.writeString(tenant);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            jgen.writeEndArray();
        }
        if (endpoint.getInherit() == null || endpoint.getInherit().equals(Boolean.FALSE)) {
            HttpClientOptions options = endpoint.getHttpClientOptions() != null ? endpoint.getHttpClientOptions() : new HttpClientOptions();
            jgen.writeObjectField("http", (Object)options);
            if (endpoint.getHttpProxy() != null) {
                jgen.writeObjectField("proxy", (Object)endpoint.getHttpProxy());
            }
            if (endpoint.getHttpClientSslOptions() != null) {
                jgen.writeObjectField("ssl", (Object)endpoint.getHttpClientSslOptions());
            }
            if (endpoint.getHeaders() != null && !endpoint.getHeaders().isEmpty()) {
                jgen.writeObjectField("headers", (Object)endpoint.getHeaders());
            }
        }
    }
}

