/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.flow.Consumer;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.PathOperator;
import io.gravitee.definition.model.flow.Step;
import java.io.IOException;

public class FlowSerializer
extends StdScalarSerializer<Flow> {
    public FlowSerializer(Class<Flow> vc) {
        super(vc);
    }

    public void serialize(Flow flow, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("name", flow.getName());
        PathOperator pathOperator = flow.getPathOperator();
        if (pathOperator != null) {
            jgen.writeObjectField("path-operator", (Object)pathOperator);
        }
        jgen.writeStringField("condition", flow.getCondition());
        jgen.writeArrayFieldStart("consumers");
        if (flow.getConsumers() != null) {
            for (Consumer consumer : flow.getConsumers()) {
                jgen.writeObject((Object)consumer);
            }
        }
        jgen.writeEndArray();
        jgen.writeArrayFieldStart("methods");
        if (flow.getMethods() != null) {
            for (HttpMethod method : flow.getMethods()) {
                jgen.writeString(method.toString().toUpperCase());
            }
        }
        jgen.writeEndArray();
        jgen.writeArrayFieldStart("pre");
        for (Step step : flow.getPre()) {
            jgen.writeObject((Object)step);
        }
        jgen.writeEndArray();
        jgen.writeArrayFieldStart("post");
        for (Step step : flow.getPost()) {
            jgen.writeObject((Object)step);
        }
        jgen.writeEndArray();
        jgen.writeBooleanField("enabled", flow.isEnabled());
        jgen.writeEndObject();
    }
}

