/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.gravitee.definition.model.Endpoint;
import java.io.IOException;

public abstract class EndpointSerializer<T extends Endpoint>
extends StdScalarSerializer<T> {
    public EndpointSerializer(Class<T> t) {
        super(t);
    }

    public void serialize(T endpoint, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        this.doSerialize(endpoint, jgen, provider);
        jgen.writeEndObject();
    }

    public void serializeWithType(T value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(value, g, provider);
    }

    protected void doSerialize(T endpoint, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
        jgen.writeStringField("name", endpoint.getName());
        jgen.writeStringField("target", endpoint.getTarget());
        jgen.writeNumberField("weight", endpoint.getWeight());
        jgen.writeBooleanField("backup", endpoint.isBackup());
        jgen.writeStringField("type", endpoint.getType().name());
        if (endpoint.getInherit() != null) {
            jgen.writeObjectField("inherit", (Object)endpoint.getInherit());
        }
    }
}

