/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser.endpoint;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.definition.jackson.datatype.api.deser.EndpointDeserializer;
import io.gravitee.definition.model.HttpClientOptions;
import io.gravitee.definition.model.HttpClientSslOptions;
import io.gravitee.definition.model.HttpProxy;
import io.gravitee.definition.model.endpoint.HttpEndpoint;
import io.gravitee.definition.model.services.healthcheck.EndpointHealthCheckService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class HttpEndpointDeserializer<T extends HttpEndpoint>
extends EndpointDeserializer<T> {
    public HttpEndpointDeserializer(Class<T> vc) {
        super(vc);
    }

    @Override
    protected T createEndpoint(String name, String target) {
        return (T)new HttpEndpoint(name, target);
    }

    @Override
    protected T deserialize(T endpoint, JsonNode node, DeserializationContext ctxt) throws IOException {
        JsonNode healthcheckNode = node.get("healthcheck");
        if (healthcheckNode != null && healthcheckNode.isObject()) {
            EndpointHealthCheckService healthCheckService = (EndpointHealthCheckService)healthcheckNode.traverse(ctxt.getParser().getCodec()).readValueAs(EndpointHealthCheckService.class);
            endpoint.setHealthCheck(healthCheckService);
        }
        if (endpoint.getInherit() == null || endpoint.getInherit().equals(Boolean.FALSE)) {
            JsonNode headersNode;
            Map<String, String> headers;
            String hostHeader;
            JsonNode hostHeaderNode;
            JsonNode httpClientOptionsNode;
            JsonNode httpProxyNode = node.get("proxy");
            if (httpProxyNode != null) {
                HttpProxy httpProxy = (HttpProxy)httpProxyNode.traverse(ctxt.getParser().getCodec()).readValueAs(HttpProxy.class);
                endpoint.setHttpProxy(httpProxy);
            }
            if ((httpClientOptionsNode = node.get("http")) != null) {
                HttpClientOptions httpClientOptions = (HttpClientOptions)httpClientOptionsNode.traverse(ctxt.getParser().getCodec()).readValueAs(HttpClientOptions.class);
                endpoint.setHttpClientOptions(httpClientOptions);
            } else {
                endpoint.setHttpClientOptions(new HttpClientOptions());
            }
            JsonNode httpClientSslOptionsNode = node.get("ssl");
            if (httpClientSslOptionsNode != null) {
                HttpClientSslOptions httpClientSslOptions = (HttpClientSslOptions)httpClientSslOptionsNode.traverse(ctxt.getParser().getCodec()).readValueAs(HttpClientSslOptions.class);
                endpoint.setHttpClientSslOptions(httpClientSslOptions);
            }
            if ((hostHeaderNode = node.get("hostHeader")) != null && !(hostHeader = hostHeaderNode.asText()).trim().isEmpty()) {
                headers = new HashMap<String, String>();
                headers.put("Host", hostHeader);
                endpoint.setHeaders(headers);
            }
            if ((headersNode = node.get("headers")) != null && !headersNode.isEmpty(null) && (headers = (Map)headersNode.traverse(ctxt.getParser().getCodec()).readValueAs((TypeReference)new TypeReference<HashMap<String, String>>(){})) != null && !headers.isEmpty()) {
                if (endpoint.getHeaders() == null) {
                    endpoint.setHeaders(headers);
                } else {
                    headers.forEach(endpoint.getHeaders()::putIfAbsent);
                }
            }
        }
        return endpoint;
    }
}

