/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser.endpoint;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.definition.jackson.datatype.api.deser.endpoint.HttpEndpointDeserializer;
import io.gravitee.definition.model.ProtocolVersion;
import io.gravitee.definition.model.endpoint.GrpcEndpoint;
import java.io.IOException;

public class GrpcEndpointDeserializer
extends HttpEndpointDeserializer<GrpcEndpoint> {
    public GrpcEndpointDeserializer(Class<GrpcEndpoint> vc) {
        super(vc);
    }

    @Override
    protected GrpcEndpoint deserialize(GrpcEndpoint endpoint, JsonNode node, DeserializationContext ctxt) throws IOException {
        GrpcEndpoint grpcEndpoint = super.deserialize(endpoint, node, ctxt);
        if (endpoint.getHttpClientOptions() != null) {
            endpoint.getHttpClientOptions().setVersion(ProtocolVersion.HTTP_2);
        }
        return grpcEndpoint;
    }

    @Override
    protected GrpcEndpoint createEndpoint(String name, String target) {
        return new GrpcEndpoint(name, target);
    }
}

