/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.Policy;
import io.gravitee.definition.model.Rule;
import java.io.IOException;
import java.util.EnumSet;

public class RuleDeserializer
extends StdScalarDeserializer<Rule> {
    public RuleDeserializer(Class<Rule> vc) {
        super(vc);
    }

    public Rule deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Rule rule = new Rule();
        EnumSet<HttpMethod> methods = EnumSet.noneOf(HttpMethod.class);
        node.fieldNames().forEachRemaining(field -> {
            JsonNode subNode = node.findValue(field);
            switch (field) {
                case "methods": {
                    if (subNode == null || !subNode.isArray()) break;
                    subNode.elements().forEachRemaining(jsonNode -> methods.add(HttpMethod.valueOf((String)jsonNode.asText().toUpperCase())));
                    break;
                }
                case "description": {
                    if (subNode == null) break;
                    rule.setDescription(subNode.asText());
                    break;
                }
                case "enabled": {
                    if (subNode == null) break;
                    rule.setEnabled(subNode.asBoolean(true));
                    break;
                }
                default: {
                    Policy policy = new Policy();
                    policy.setName(field);
                    policy.setConfiguration(subNode.toString());
                    rule.setPolicy(policy);
                }
            }
        });
        rule.setMethods(methods.isEmpty() ? EnumSet.allOf(HttpMethod.class) : methods);
        return rule;
    }
}

