/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.definition.jackson.datatype.api.deser.AbstractStdScalarDeserializer;
import io.gravitee.definition.model.HttpClientOptions;
import io.gravitee.definition.model.ProtocolVersion;
import java.io.IOException;

public class HttpClientOptionsDeserializer
extends AbstractStdScalarDeserializer<HttpClientOptions> {
    public HttpClientOptionsDeserializer(Class<HttpClientOptions> vc) {
        super(vc);
    }

    public HttpClientOptions deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        HttpClientOptions httpClientOptions = new HttpClientOptions();
        httpClientOptions.setConnectTimeout(node.path("connectTimeout").asLong(HttpClientOptions.DEFAULT_CONNECT_TIMEOUT));
        httpClientOptions.setReadTimeout(node.path("readTimeout").asLong(HttpClientOptions.DEFAULT_READ_TIMEOUT));
        httpClientOptions.setIdleTimeout(node.path("idleTimeout").asLong(HttpClientOptions.DEFAULT_IDLE_TIMEOUT));
        httpClientOptions.setKeepAlive(node.path("keepAlive").asBoolean(HttpClientOptions.DEFAULT_KEEP_ALIVE));
        httpClientOptions.setPipelining(node.path("pipelining").asBoolean(HttpClientOptions.DEFAULT_PIPELINING));
        httpClientOptions.setMaxConcurrentConnections(node.path("maxConcurrentConnections").asInt(HttpClientOptions.DEFAULT_MAX_CONCURRENT_CONNECTIONS));
        httpClientOptions.setUseCompression(node.path("useCompression").asBoolean(HttpClientOptions.DEFAULT_USE_COMPRESSION));
        httpClientOptions.setFollowRedirects(node.path("followRedirects").asBoolean(HttpClientOptions.DEFAULT_FOLLOW_REDIRECTS));
        if (node.get("clearTextUpgrade") != null) {
            httpClientOptions.setClearTextUpgrade(node.get("clearTextUpgrade").asBoolean(HttpClientOptions.DEFAULT_CLEAR_TEXT_UPGRADE));
        }
        if (node.get("version") != null) {
            httpClientOptions.setVersion(ProtocolVersion.valueOf((String)node.path("version").asText(HttpClientOptions.DEFAULT_PROTOCOL_VERSION.name())));
        }
        return httpClientOptions;
    }
}

