/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.Failover;
import io.gravitee.definition.model.FailoverCase;
import java.io.IOException;
import java.util.ArrayList;

public class FailoverDeserializer
extends StdScalarDeserializer<Failover> {
    public FailoverDeserializer(Class<Failover> vc) {
        super(vc);
    }

    public Failover deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode maxAttemptsNode;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Failover failover = new Failover();
        JsonNode casesNode = node.get("cases");
        if (casesNode != null) {
            if (casesNode.isArray()) {
                ArrayList cases = new ArrayList();
                casesNode.elements().forEachRemaining(jsonNode -> cases.add(FailoverCase.valueOf((String)jsonNode.asText().toUpperCase())));
                failover.setCases(cases.toArray(new FailoverCase[cases.size()]));
            } else {
                failover.setCases(new FailoverCase[]{FailoverCase.valueOf((String)casesNode.asText().toUpperCase())});
            }
        }
        if ((maxAttemptsNode = node.get("maxAttempts")) != null) {
            int maxAttempts = maxAttemptsNode.asInt(Failover.DEFAULT_MAX_ATTEMPTS);
            failover.setMaxAttempts(maxAttempts);
        } else {
            failover.setMaxAttempts(Failover.DEFAULT_MAX_ATTEMPTS);
        }
        JsonNode retryTimeoutNode = node.get("retryTimeout");
        if (retryTimeoutNode != null) {
            long retryTimeout = retryTimeoutNode.asLong(Failover.DEFAULT_RETRY_TIMEOUT);
            failover.setRetryTimeout(retryTimeout);
        } else {
            failover.setRetryTimeout(Failover.DEFAULT_RETRY_TIMEOUT);
        }
        return failover;
    }
}

