/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import io.gravitee.definition.model.Endpoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public abstract class EndpointDeserializer<T extends Endpoint>
extends StdScalarDeserializer<T> {
    public EndpointDeserializer(Class<T> vc) {
        super(vc);
    }

    public T deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonNode inheritNode;
        JsonNode tenantsNode;
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        JsonNode nameNode = node.get("name");
        if (nameNode == null) {
            throw ctxt.mappingException("Endpoint name is required");
        }
        String name = nameNode.asText();
        JsonNode targetNode = node.get("target");
        if (targetNode == null) {
            throw ctxt.mappingException("Endpoint target is required");
        }
        String target = targetNode.asText();
        T endpoint = this.createEndpoint(name, target);
        JsonNode weightNode = node.get("weight");
        if (weightNode != null) {
            int weight = weightNode.asInt(1);
            endpoint.setWeight(weight);
        } else {
            endpoint.setWeight(1);
        }
        JsonNode backupNode = node.get("backup");
        if (backupNode != null) {
            boolean backup = backupNode.asBoolean(false);
            endpoint.setBackup(backup);
        } else {
            endpoint.setBackup(false);
        }
        JsonNode singleTenantNode = node.get("tenant");
        if (singleTenantNode != null) {
            String tenant = singleTenantNode.asText();
            endpoint.setTenants(Collections.singletonList(tenant));
        }
        if ((tenantsNode = node.get("tenants")) != null && tenantsNode.isArray()) {
            ArrayList tenants = new ArrayList(tenantsNode.size());
            tenantsNode.elements().forEachRemaining(tenantNode -> tenants.add(tenantNode.asText()));
            endpoint.setTenants(tenants);
        }
        if ((inheritNode = node.get("inherit")) != null) {
            endpoint.setInherit(Boolean.valueOf(inheritNode.asBoolean()));
        }
        this.deserialize(endpoint, node, ctxt);
        return endpoint;
    }

    protected abstract T createEndpoint(String var1, String var2);

    protected abstract T deserialize(T var1, JsonNode var2, DeserializationContext var3) throws IOException;

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(p, ctxt);
    }
}

