/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.definition.model.FlowMode;
import io.gravitee.definition.model.Plan;
import io.gravitee.definition.model.Properties;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.Service;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.definition.model.services.Services;
import io.gravitee.definition.model.services.discovery.EndpointDiscoveryService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiDeserializer
extends StdScalarDeserializer<Api> {
    private final Logger logger = LoggerFactory.getLogger(ApiDeserializer.class);

    public ApiDeserializer(Class<Api> vc) {
        super(vc);
    }

    public Api deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode responseTemplatesNode;
        JsonNode pathMappingsNode;
        JsonNode tagsNode;
        JsonNode propertiesNode;
        JsonNode resourcesNode;
        EndpointDiscoveryService discoveryService;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Api api = new Api();
        JsonNode idNode = node.get("id");
        if (idNode == null) {
            throw ctxt.mappingException("ID property is required");
        }
        api.setId(idNode.asText());
        JsonNode nameNode = node.get("name");
        if (nameNode == null) {
            throw ctxt.mappingException("Name property is required");
        }
        api.setName(nameNode.asText());
        JsonNode versionNode = node.get("version");
        if (versionNode == null) {
            api.setVersion("undefined");
        } else {
            api.setVersion(versionNode.asText());
        }
        JsonNode proxyNode = node.get("proxy");
        if (proxyNode == null) {
            this.logger.error("A proxy property is required for {}", (Object)api.getName());
            throw ctxt.mappingException("A proxy property is required for " + api.getName());
        }
        api.setProxy((Proxy)proxyNode.traverse(jp.getCodec()).readValueAs(Proxy.class));
        JsonNode servicesNode = node.get("services");
        if (servicesNode != null) {
            Services services = (Services)servicesNode.traverse(jp.getCodec()).readValueAs(Services.class);
            api.getServices().set(services.getAll());
        }
        if (api.getServices() != null && (discoveryService = (EndpointDiscoveryService)api.getServices().get(EndpointDiscoveryService.class)) != null) {
            api.getServices().remove(EndpointDiscoveryService.class);
            Set endpointGroups = api.getProxy().getGroups();
            if (endpointGroups != null && !endpointGroups.isEmpty()) {
                EndpointGroup defaultGroup = (EndpointGroup)endpointGroups.iterator().next();
                defaultGroup.getServices().put(EndpointDiscoveryService.class, (Service)discoveryService);
            }
        }
        if ((resourcesNode = node.get("resources")) != null && resourcesNode.isArray()) {
            resourcesNode.elements().forEachRemaining(resourceNode -> {
                try {
                    Resource resource = (Resource)resourceNode.traverse(jp.getCodec()).readValueAs(Resource.class);
                    if (api.getResources().contains(resource)) {
                        throw ctxt.mappingException("A resource already exists with name " + resource.getName());
                    }
                    api.getResources().add(resource);
                }
                catch (IOException e) {
                    this.logger.error("An error occurred during api deserialization", (Throwable)e);
                }
            });
        }
        api.setDefinitionVersion(DefinitionVersion.valueOfLabel((String)node.path("gravitee").asText(DefinitionVersion.V1.getLabel())));
        api.setFlowMode(FlowMode.valueOf((String)node.path("flow_mode").asText(FlowMode.DEFAULT.name())));
        if (api.getDefinitionVersion() == DefinitionVersion.V1) {
            if (node.get("flows") != null) {
                throw ctxt.mappingException("Flows are only available for definition >= 2.x.x ");
            }
            JsonNode pathsNode = node.get("paths");
            if (pathsNode != null) {
                TreeMap paths = new TreeMap(Comparator.reverseOrder());
                pathsNode.fields().forEachRemaining(jsonNode -> {
                    try {
                        List rules = (List)((JsonNode)jsonNode.getValue()).traverse(jp.getCodec()).readValueAs((TypeReference)new TypeReference<List<Rule>>(){});
                        paths.put((String)jsonNode.getKey(), rules);
                    }
                    catch (IOException e) {
                        this.logger.error("Path {} can not be de-serialized", jsonNode.getKey());
                    }
                });
                api.setPaths(paths);
            }
        }
        if (api.getDefinitionVersion() == DefinitionVersion.V2) {
            JsonNode plansNode;
            if (node.get("paths") != null) {
                throw ctxt.mappingException("Paths are only available for definition 1.x.x ");
            }
            JsonNode flowsNode = node.get("flows");
            if (flowsNode != null) {
                ArrayList flows = new ArrayList();
                flowsNode.elements().forEachRemaining(jsonNode -> {
                    try {
                        Flow flow = (Flow)jsonNode.traverse(jp.getCodec()).readValueAs(Flow.class);
                        flows.add(flow);
                    }
                    catch (IOException e) {
                        this.logger.error("Flow {} can not be de-serialized", (Object)jsonNode.asText());
                    }
                });
                api.setFlows(flows);
            }
            if ((plansNode = node.get("plans")) != null) {
                ArrayList plans = new ArrayList();
                plansNode.elements().forEachRemaining(jsonNode -> {
                    try {
                        Plan plan = (Plan)jsonNode.traverse(jp.getCodec()).readValueAs(Plan.class);
                        plans.add(plan);
                    }
                    catch (IOException e) {
                        this.logger.error("Plan {} can not be de-serialized", (Object)jsonNode.asText());
                    }
                });
                api.setPlans(plans);
            }
        }
        if ((propertiesNode = node.get("properties")) != null) {
            Properties properties = (Properties)propertiesNode.traverse(jp.getCodec()).readValueAs(Properties.class);
            api.setProperties(properties);
        }
        if ((tagsNode = node.get("tags")) != null && tagsNode.isArray()) {
            tagsNode.elements().forEachRemaining(jsonNode -> api.getTags().add(jsonNode.asText()));
        }
        if ((pathMappingsNode = node.get("path_mappings")) != null) {
            pathMappingsNode.elements().forEachRemaining(jsonNode -> {
                String pathMapping = jsonNode.asText();
                api.getPathMappings().put(pathMapping, Pattern.compile(pathMapping.replaceAll(":\\w*", "[^\\/]*") + "/*"));
            });
        }
        if ((responseTemplatesNode = node.get("response_templates")) != null) {
            HashMap responseTemplates = new HashMap();
            responseTemplatesNode.fields().forEachRemaining(jsonNode -> {
                try {
                    Map templates = (Map)((JsonNode)jsonNode.getValue()).traverse(jp.getCodec()).readValueAs((TypeReference)new TypeReference<Map<String, ResponseTemplate>>(){});
                    responseTemplates.put((String)jsonNode.getKey(), templates);
                }
                catch (IOException e) {
                    this.logger.error("Response templates {} can not be de-serialized", jsonNode.getKey());
                }
            });
            api.setResponseTemplates(responseTemplates);
        }
        return api;
    }
}

