/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.common.mapper;

import io.gravitee.apim.common.mapper.HttpClientOptionsMapper;
import io.gravitee.definition.model.v4.http.HttpClientOptions;
import io.gravitee.definition.model.v4.http.ProtocolVersion;
import io.gravitee.node.vertx.client.http.VertxHttpClientOptions;
import io.gravitee.node.vertx.client.http.VertxHttpProtocolVersion;

public class HttpClientOptionsMapperImpl
implements HttpClientOptionsMapper {
    @Override
    public VertxHttpClientOptions map(HttpClientOptions httpClientOptions) {
        if (httpClientOptions == null) {
            return null;
        }
        VertxHttpClientOptions.VertxHttpClientOptionsBuilder vertxHttpClientOptions = VertxHttpClientOptions.builder();
        vertxHttpClientOptions.http2MultiplexingLimit(httpClientOptions.getHttp2MultiplexingLimit());
        vertxHttpClientOptions.http2ConnectionWindowSize(httpClientOptions.getHttp2ConnectionWindowSize());
        vertxHttpClientOptions.http2StreamWindowSize(httpClientOptions.getHttp2StreamWindowSize());
        vertxHttpClientOptions.http2MaxFrameSize(httpClientOptions.getHttp2MaxFrameSize());
        vertxHttpClientOptions.idleTimeout(httpClientOptions.getIdleTimeout());
        vertxHttpClientOptions.keepAliveTimeout(httpClientOptions.getKeepAliveTimeout());
        vertxHttpClientOptions.connectTimeout(httpClientOptions.getConnectTimeout());
        vertxHttpClientOptions.keepAlive(httpClientOptions.isKeepAlive());
        vertxHttpClientOptions.readTimeout(httpClientOptions.getReadTimeout());
        vertxHttpClientOptions.pipelining(httpClientOptions.isPipelining());
        vertxHttpClientOptions.maxConcurrentConnections(httpClientOptions.getMaxConcurrentConnections());
        vertxHttpClientOptions.useCompression(httpClientOptions.isUseCompression());
        vertxHttpClientOptions.clearTextUpgrade(httpClientOptions.isClearTextUpgrade());
        vertxHttpClientOptions.version(this.protocolVersionToVertxHttpProtocolVersion(httpClientOptions.getVersion()));
        return vertxHttpClientOptions.build();
    }

    protected VertxHttpProtocolVersion protocolVersionToVertxHttpProtocolVersion(ProtocolVersion protocolVersion) {
        if (protocolVersion == null) {
            return null;
        }
        return switch (protocolVersion) {
            case ProtocolVersion.HTTP_1_1 -> VertxHttpProtocolVersion.HTTP_1_1;
            case ProtocolVersion.HTTP_2 -> VertxHttpProtocolVersion.HTTP_2;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(protocolVersion));
        };
    }
}

