/*
 * Decompiled with CFR 0.152.
 */
package io.grafeas.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OccurrenceName
implements ResourceName {
    private static final PathTemplate PROJECT_OCCURRENCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/occurrences/{occurrence}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String occurrence;

    @Deprecated
    protected OccurrenceName() {
        this.project = null;
        this.occurrence = null;
    }

    private OccurrenceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.occurrence = (String)Preconditions.checkNotNull((Object)builder.getOccurrence());
    }

    public String getProject() {
        return this.project;
    }

    public String getOccurrence() {
        return this.occurrence;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OccurrenceName of(String project, String occurrence) {
        return OccurrenceName.newBuilder().setProject(project).setOccurrence(occurrence).build();
    }

    public static String format(String project, String occurrence) {
        return OccurrenceName.newBuilder().setProject(project).setOccurrence(occurrence).build().toString();
    }

    public static OccurrenceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_OCCURRENCE.validatedMatch(formattedString, "OccurrenceName.parse: formattedString not in valid format");
        return OccurrenceName.of((String)matchMap.get("project"), (String)matchMap.get("occurrence"));
    }

    public static List<OccurrenceName> parseList(List<String> formattedStrings) {
        ArrayList<OccurrenceName> list = new ArrayList<OccurrenceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OccurrenceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OccurrenceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OccurrenceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_OCCURRENCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OccurrenceName occurrenceName = this;
            synchronized (occurrenceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.occurrence != null) {
                        fieldMapBuilder.put((Object)"occurrence", (Object)this.occurrence);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_OCCURRENCE.instantiate(new String[]{"project", this.project, "occurrence", this.occurrence});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            OccurrenceName that = (OccurrenceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.occurrence, that.occurrence);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.occurrence);
    }

    public static class Builder {
        private String project;
        private String occurrence;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getOccurrence() {
            return this.occurrence;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setOccurrence(String occurrence) {
            this.occurrence = occurrence;
            return this;
        }

        private Builder(OccurrenceName occurrenceName) {
            this.project = occurrenceName.project;
            this.occurrence = occurrenceName.occurrence;
        }

        public OccurrenceName build() {
            return new OccurrenceName(this);
        }
    }
}

