/*
 * Decompiled with CFR 0.152.
 */
package io.grafeas.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import io.grafeas.v1.BatchCreateNotesRequest;
import io.grafeas.v1.BatchCreateNotesResponse;
import io.grafeas.v1.BatchCreateOccurrencesRequest;
import io.grafeas.v1.BatchCreateOccurrencesResponse;
import io.grafeas.v1.CreateNoteRequest;
import io.grafeas.v1.CreateOccurrenceRequest;
import io.grafeas.v1.DeleteNoteRequest;
import io.grafeas.v1.DeleteOccurrenceRequest;
import io.grafeas.v1.GetNoteRequest;
import io.grafeas.v1.GetOccurrenceNoteRequest;
import io.grafeas.v1.GetOccurrenceRequest;
import io.grafeas.v1.GrafeasSettings;
import io.grafeas.v1.ListNoteOccurrencesRequest;
import io.grafeas.v1.ListNoteOccurrencesResponse;
import io.grafeas.v1.ListNotesRequest;
import io.grafeas.v1.ListNotesResponse;
import io.grafeas.v1.ListOccurrencesRequest;
import io.grafeas.v1.ListOccurrencesResponse;
import io.grafeas.v1.Note;
import io.grafeas.v1.NoteName;
import io.grafeas.v1.Occurrence;
import io.grafeas.v1.OccurrenceName;
import io.grafeas.v1.ProjectName;
import io.grafeas.v1.UpdateNoteRequest;
import io.grafeas.v1.UpdateOccurrenceRequest;
import io.grafeas.v1.stub.GrafeasStub;
import io.grafeas.v1.stub.GrafeasStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class GrafeasClient
implements BackgroundResource {
    private final GrafeasSettings settings;
    private final GrafeasStub stub;

    public static final GrafeasClient create() throws IOException {
        return GrafeasClient.create(GrafeasSettings.newBuilder().build());
    }

    public static final GrafeasClient create(GrafeasSettings settings) throws IOException {
        return new GrafeasClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GrafeasClient create(GrafeasStub stub) {
        return new GrafeasClient(stub);
    }

    protected GrafeasClient(GrafeasSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GrafeasStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GrafeasClient(GrafeasStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GrafeasSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GrafeasStub getStub() {
        return this.stub;
    }

    public final Occurrence getOccurrence(OccurrenceName name) {
        GetOccurrenceRequest request = GetOccurrenceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getOccurrence(request);
    }

    public final Occurrence getOccurrence(String name) {
        GetOccurrenceRequest request = GetOccurrenceRequest.newBuilder().setName(name).build();
        return this.getOccurrence(request);
    }

    public final Occurrence getOccurrence(GetOccurrenceRequest request) {
        return (Occurrence)this.getOccurrenceCallable().call((Object)request);
    }

    public final UnaryCallable<GetOccurrenceRequest, Occurrence> getOccurrenceCallable() {
        return this.stub.getOccurrenceCallable();
    }

    public final ListOccurrencesPagedResponse listOccurrences(ProjectName parent, String filter) {
        ListOccurrencesRequest request = ListOccurrencesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFilter(filter).build();
        return this.listOccurrences(request);
    }

    public final ListOccurrencesPagedResponse listOccurrences(String parent, String filter) {
        ListOccurrencesRequest request = ListOccurrencesRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listOccurrences(request);
    }

    public final ListOccurrencesPagedResponse listOccurrences(ListOccurrencesRequest request) {
        return (ListOccurrencesPagedResponse)((Object)this.listOccurrencesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOccurrencesRequest, ListOccurrencesPagedResponse> listOccurrencesPagedCallable() {
        return this.stub.listOccurrencesPagedCallable();
    }

    public final UnaryCallable<ListOccurrencesRequest, ListOccurrencesResponse> listOccurrencesCallable() {
        return this.stub.listOccurrencesCallable();
    }

    public final void deleteOccurrence(OccurrenceName name) {
        DeleteOccurrenceRequest request = DeleteOccurrenceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteOccurrence(request);
    }

    public final void deleteOccurrence(String name) {
        DeleteOccurrenceRequest request = DeleteOccurrenceRequest.newBuilder().setName(name).build();
        this.deleteOccurrence(request);
    }

    public final void deleteOccurrence(DeleteOccurrenceRequest request) {
        this.deleteOccurrenceCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteOccurrenceRequest, Empty> deleteOccurrenceCallable() {
        return this.stub.deleteOccurrenceCallable();
    }

    public final Occurrence createOccurrence(ProjectName parent, Occurrence occurrence) {
        CreateOccurrenceRequest request = CreateOccurrenceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setOccurrence(occurrence).build();
        return this.createOccurrence(request);
    }

    public final Occurrence createOccurrence(String parent, Occurrence occurrence) {
        CreateOccurrenceRequest request = CreateOccurrenceRequest.newBuilder().setParent(parent).setOccurrence(occurrence).build();
        return this.createOccurrence(request);
    }

    public final Occurrence createOccurrence(CreateOccurrenceRequest request) {
        return (Occurrence)this.createOccurrenceCallable().call((Object)request);
    }

    public final UnaryCallable<CreateOccurrenceRequest, Occurrence> createOccurrenceCallable() {
        return this.stub.createOccurrenceCallable();
    }

    public final BatchCreateOccurrencesResponse batchCreateOccurrences(ProjectName parent, List<Occurrence> occurrences) {
        BatchCreateOccurrencesRequest request = BatchCreateOccurrencesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllOccurrences(occurrences).build();
        return this.batchCreateOccurrences(request);
    }

    public final BatchCreateOccurrencesResponse batchCreateOccurrences(String parent, List<Occurrence> occurrences) {
        BatchCreateOccurrencesRequest request = BatchCreateOccurrencesRequest.newBuilder().setParent(parent).addAllOccurrences(occurrences).build();
        return this.batchCreateOccurrences(request);
    }

    public final BatchCreateOccurrencesResponse batchCreateOccurrences(BatchCreateOccurrencesRequest request) {
        return (BatchCreateOccurrencesResponse)this.batchCreateOccurrencesCallable().call((Object)request);
    }

    public final UnaryCallable<BatchCreateOccurrencesRequest, BatchCreateOccurrencesResponse> batchCreateOccurrencesCallable() {
        return this.stub.batchCreateOccurrencesCallable();
    }

    public final Occurrence updateOccurrence(OccurrenceName name, Occurrence occurrence, FieldMask updateMask) {
        UpdateOccurrenceRequest request = UpdateOccurrenceRequest.newBuilder().setName(name == null ? null : name.toString()).setOccurrence(occurrence).setUpdateMask(updateMask).build();
        return this.updateOccurrence(request);
    }

    public final Occurrence updateOccurrence(String name, Occurrence occurrence, FieldMask updateMask) {
        UpdateOccurrenceRequest request = UpdateOccurrenceRequest.newBuilder().setName(name).setOccurrence(occurrence).setUpdateMask(updateMask).build();
        return this.updateOccurrence(request);
    }

    public final Occurrence updateOccurrence(UpdateOccurrenceRequest request) {
        return (Occurrence)this.updateOccurrenceCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateOccurrenceRequest, Occurrence> updateOccurrenceCallable() {
        return this.stub.updateOccurrenceCallable();
    }

    public final Note getOccurrenceNote(OccurrenceName name) {
        GetOccurrenceNoteRequest request = GetOccurrenceNoteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getOccurrenceNote(request);
    }

    public final Note getOccurrenceNote(String name) {
        GetOccurrenceNoteRequest request = GetOccurrenceNoteRequest.newBuilder().setName(name).build();
        return this.getOccurrenceNote(request);
    }

    public final Note getOccurrenceNote(GetOccurrenceNoteRequest request) {
        return (Note)this.getOccurrenceNoteCallable().call((Object)request);
    }

    public final UnaryCallable<GetOccurrenceNoteRequest, Note> getOccurrenceNoteCallable() {
        return this.stub.getOccurrenceNoteCallable();
    }

    public final Note getNote(NoteName name) {
        GetNoteRequest request = GetNoteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNote(request);
    }

    public final Note getNote(String name) {
        GetNoteRequest request = GetNoteRequest.newBuilder().setName(name).build();
        return this.getNote(request);
    }

    public final Note getNote(GetNoteRequest request) {
        return (Note)this.getNoteCallable().call((Object)request);
    }

    public final UnaryCallable<GetNoteRequest, Note> getNoteCallable() {
        return this.stub.getNoteCallable();
    }

    public final ListNotesPagedResponse listNotes(ProjectName parent, String filter) {
        ListNotesRequest request = ListNotesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFilter(filter).build();
        return this.listNotes(request);
    }

    public final ListNotesPagedResponse listNotes(String parent, String filter) {
        ListNotesRequest request = ListNotesRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listNotes(request);
    }

    public final ListNotesPagedResponse listNotes(ListNotesRequest request) {
        return (ListNotesPagedResponse)((Object)this.listNotesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNotesRequest, ListNotesPagedResponse> listNotesPagedCallable() {
        return this.stub.listNotesPagedCallable();
    }

    public final UnaryCallable<ListNotesRequest, ListNotesResponse> listNotesCallable() {
        return this.stub.listNotesCallable();
    }

    public final void deleteNote(NoteName name) {
        DeleteNoteRequest request = DeleteNoteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteNote(request);
    }

    public final void deleteNote(String name) {
        DeleteNoteRequest request = DeleteNoteRequest.newBuilder().setName(name).build();
        this.deleteNote(request);
    }

    public final void deleteNote(DeleteNoteRequest request) {
        this.deleteNoteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteNoteRequest, Empty> deleteNoteCallable() {
        return this.stub.deleteNoteCallable();
    }

    public final Note createNote(ProjectName parent, String noteId, Note note) {
        CreateNoteRequest request = CreateNoteRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNoteId(noteId).setNote(note).build();
        return this.createNote(request);
    }

    public final Note createNote(String parent, String noteId, Note note) {
        CreateNoteRequest request = CreateNoteRequest.newBuilder().setParent(parent).setNoteId(noteId).setNote(note).build();
        return this.createNote(request);
    }

    public final Note createNote(CreateNoteRequest request) {
        return (Note)this.createNoteCallable().call((Object)request);
    }

    public final UnaryCallable<CreateNoteRequest, Note> createNoteCallable() {
        return this.stub.createNoteCallable();
    }

    public final BatchCreateNotesResponse batchCreateNotes(ProjectName parent, Map<String, Note> notes) {
        BatchCreateNotesRequest request = BatchCreateNotesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).putAllNotes(notes).build();
        return this.batchCreateNotes(request);
    }

    public final BatchCreateNotesResponse batchCreateNotes(String parent, Map<String, Note> notes) {
        BatchCreateNotesRequest request = BatchCreateNotesRequest.newBuilder().setParent(parent).putAllNotes(notes).build();
        return this.batchCreateNotes(request);
    }

    public final BatchCreateNotesResponse batchCreateNotes(BatchCreateNotesRequest request) {
        return (BatchCreateNotesResponse)this.batchCreateNotesCallable().call((Object)request);
    }

    public final UnaryCallable<BatchCreateNotesRequest, BatchCreateNotesResponse> batchCreateNotesCallable() {
        return this.stub.batchCreateNotesCallable();
    }

    public final Note updateNote(NoteName name, Note note, FieldMask updateMask) {
        UpdateNoteRequest request = UpdateNoteRequest.newBuilder().setName(name == null ? null : name.toString()).setNote(note).setUpdateMask(updateMask).build();
        return this.updateNote(request);
    }

    public final Note updateNote(String name, Note note, FieldMask updateMask) {
        UpdateNoteRequest request = UpdateNoteRequest.newBuilder().setName(name).setNote(note).setUpdateMask(updateMask).build();
        return this.updateNote(request);
    }

    public final Note updateNote(UpdateNoteRequest request) {
        return (Note)this.updateNoteCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateNoteRequest, Note> updateNoteCallable() {
        return this.stub.updateNoteCallable();
    }

    public final ListNoteOccurrencesPagedResponse listNoteOccurrences(NoteName name, String filter) {
        ListNoteOccurrencesRequest request = ListNoteOccurrencesRequest.newBuilder().setName(name == null ? null : name.toString()).setFilter(filter).build();
        return this.listNoteOccurrences(request);
    }

    public final ListNoteOccurrencesPagedResponse listNoteOccurrences(String name, String filter) {
        ListNoteOccurrencesRequest request = ListNoteOccurrencesRequest.newBuilder().setName(name).setFilter(filter).build();
        return this.listNoteOccurrences(request);
    }

    public final ListNoteOccurrencesPagedResponse listNoteOccurrences(ListNoteOccurrencesRequest request) {
        return (ListNoteOccurrencesPagedResponse)((Object)this.listNoteOccurrencesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNoteOccurrencesRequest, ListNoteOccurrencesPagedResponse> listNoteOccurrencesPagedCallable() {
        return this.stub.listNoteOccurrencesPagedCallable();
    }

    public final UnaryCallable<ListNoteOccurrencesRequest, ListNoteOccurrencesResponse> listNoteOccurrencesCallable() {
        return this.stub.listNoteOccurrencesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListNoteOccurrencesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNoteOccurrencesRequest, ListNoteOccurrencesResponse, Occurrence, ListNoteOccurrencesPage, ListNoteOccurrencesFixedSizeCollection> {
        private ListNoteOccurrencesFixedSizeCollection(List<ListNoteOccurrencesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNoteOccurrencesFixedSizeCollection createEmptyCollection() {
            return new ListNoteOccurrencesFixedSizeCollection(null, 0);
        }

        protected ListNoteOccurrencesFixedSizeCollection createCollection(List<ListNoteOccurrencesPage> pages, int collectionSize) {
            return new ListNoteOccurrencesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNoteOccurrencesPage
    extends AbstractPage<ListNoteOccurrencesRequest, ListNoteOccurrencesResponse, Occurrence, ListNoteOccurrencesPage> {
        private ListNoteOccurrencesPage(PageContext<ListNoteOccurrencesRequest, ListNoteOccurrencesResponse, Occurrence> context, ListNoteOccurrencesResponse response) {
            super(context, (Object)response);
        }

        private static ListNoteOccurrencesPage createEmptyPage() {
            return new ListNoteOccurrencesPage(null, null);
        }

        protected ListNoteOccurrencesPage createPage(PageContext<ListNoteOccurrencesRequest, ListNoteOccurrencesResponse, Occurrence> context, ListNoteOccurrencesResponse response) {
            return new ListNoteOccurrencesPage(context, response);
        }

        public ApiFuture<ListNoteOccurrencesPage> createPageAsync(PageContext<ListNoteOccurrencesRequest, ListNoteOccurrencesResponse, Occurrence> context, ApiFuture<ListNoteOccurrencesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNoteOccurrencesPagedResponse
    extends AbstractPagedListResponse<ListNoteOccurrencesRequest, ListNoteOccurrencesResponse, Occurrence, ListNoteOccurrencesPage, ListNoteOccurrencesFixedSizeCollection> {
        public static ApiFuture<ListNoteOccurrencesPagedResponse> createAsync(PageContext<ListNoteOccurrencesRequest, ListNoteOccurrencesResponse, Occurrence> context, ApiFuture<ListNoteOccurrencesResponse> futureResponse) {
            ApiFuture<ListNoteOccurrencesPage> futurePage = ListNoteOccurrencesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListNoteOccurrencesPage, ListNoteOccurrencesPagedResponse>(){

                public ListNoteOccurrencesPagedResponse apply(ListNoteOccurrencesPage input) {
                    return new ListNoteOccurrencesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListNoteOccurrencesPagedResponse(ListNoteOccurrencesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNoteOccurrencesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNotesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNotesRequest, ListNotesResponse, Note, ListNotesPage, ListNotesFixedSizeCollection> {
        private ListNotesFixedSizeCollection(List<ListNotesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNotesFixedSizeCollection createEmptyCollection() {
            return new ListNotesFixedSizeCollection(null, 0);
        }

        protected ListNotesFixedSizeCollection createCollection(List<ListNotesPage> pages, int collectionSize) {
            return new ListNotesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNotesPage
    extends AbstractPage<ListNotesRequest, ListNotesResponse, Note, ListNotesPage> {
        private ListNotesPage(PageContext<ListNotesRequest, ListNotesResponse, Note> context, ListNotesResponse response) {
            super(context, (Object)response);
        }

        private static ListNotesPage createEmptyPage() {
            return new ListNotesPage(null, null);
        }

        protected ListNotesPage createPage(PageContext<ListNotesRequest, ListNotesResponse, Note> context, ListNotesResponse response) {
            return new ListNotesPage(context, response);
        }

        public ApiFuture<ListNotesPage> createPageAsync(PageContext<ListNotesRequest, ListNotesResponse, Note> context, ApiFuture<ListNotesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNotesPagedResponse
    extends AbstractPagedListResponse<ListNotesRequest, ListNotesResponse, Note, ListNotesPage, ListNotesFixedSizeCollection> {
        public static ApiFuture<ListNotesPagedResponse> createAsync(PageContext<ListNotesRequest, ListNotesResponse, Note> context, ApiFuture<ListNotesResponse> futureResponse) {
            ApiFuture<ListNotesPage> futurePage = ListNotesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListNotesPage, ListNotesPagedResponse>(){

                public ListNotesPagedResponse apply(ListNotesPage input) {
                    return new ListNotesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListNotesPagedResponse(ListNotesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNotesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListOccurrencesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOccurrencesRequest, ListOccurrencesResponse, Occurrence, ListOccurrencesPage, ListOccurrencesFixedSizeCollection> {
        private ListOccurrencesFixedSizeCollection(List<ListOccurrencesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListOccurrencesFixedSizeCollection createEmptyCollection() {
            return new ListOccurrencesFixedSizeCollection(null, 0);
        }

        protected ListOccurrencesFixedSizeCollection createCollection(List<ListOccurrencesPage> pages, int collectionSize) {
            return new ListOccurrencesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListOccurrencesPage
    extends AbstractPage<ListOccurrencesRequest, ListOccurrencesResponse, Occurrence, ListOccurrencesPage> {
        private ListOccurrencesPage(PageContext<ListOccurrencesRequest, ListOccurrencesResponse, Occurrence> context, ListOccurrencesResponse response) {
            super(context, (Object)response);
        }

        private static ListOccurrencesPage createEmptyPage() {
            return new ListOccurrencesPage(null, null);
        }

        protected ListOccurrencesPage createPage(PageContext<ListOccurrencesRequest, ListOccurrencesResponse, Occurrence> context, ListOccurrencesResponse response) {
            return new ListOccurrencesPage(context, response);
        }

        public ApiFuture<ListOccurrencesPage> createPageAsync(PageContext<ListOccurrencesRequest, ListOccurrencesResponse, Occurrence> context, ApiFuture<ListOccurrencesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListOccurrencesPagedResponse
    extends AbstractPagedListResponse<ListOccurrencesRequest, ListOccurrencesResponse, Occurrence, ListOccurrencesPage, ListOccurrencesFixedSizeCollection> {
        public static ApiFuture<ListOccurrencesPagedResponse> createAsync(PageContext<ListOccurrencesRequest, ListOccurrencesResponse, Occurrence> context, ApiFuture<ListOccurrencesResponse> futureResponse) {
            ApiFuture<ListOccurrencesPage> futurePage = ListOccurrencesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListOccurrencesPage, ListOccurrencesPagedResponse>(){

                public ListOccurrencesPagedResponse apply(ListOccurrencesPage input) {
                    return new ListOccurrencesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListOccurrencesPagedResponse(ListOccurrencesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListOccurrencesFixedSizeCollection.createEmptyCollection());
        }
    }
}

